/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.SchemaComparator;
import org.eobjects.datacleaner.widgets.DCListCellRenderer;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.NamedStructure;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

public class SchemaStructureComboBoxListRenderer
extends DCListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private boolean indentEnabled;
    private String nullText = "- none -";

    public SchemaStructureComboBoxListRenderer() {
        this(true);
    }

    public SchemaStructureComboBoxListRenderer(boolean indentsEnabled) {
        this.indentEnabled = indentsEnabled;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        int indent = 0;
        Icon icon = null;
        if (value == null) {
            result.setText(this.getNullText());
        } else if (value instanceof NamedStructure) {
            result.setText(((NamedStructure)value).getName());
            if (value instanceof Schema) {
                icon = imageManager.getImageIcon("images/model/schema.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                icon = SchemaComparator.isInformationSchema((Schema)value) ? imageManager.getImageIcon("images/model/schema_information.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]) : imageManager.getImageIcon("images/model/schema.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
            } else if (value instanceof Table) {
                icon = imageManager.getImageIcon("images/model/table.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                indent = 10;
            } else if (value instanceof Column) {
                icon = imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                indent = 20;
            }
        } else if (value instanceof Datastore) {
            Datastore datastore = (Datastore)value;
            icon = IconUtils.getDatastoreIcon(datastore, IconUtils.ICON_SIZE_SMALL);
            result.setText(datastore.getName());
        } else if (value instanceof InputColumn) {
            result.setText(((InputColumn)value).getName());
            icon = imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
        }
        if (icon != null) {
            result.setIcon(icon);
        }
        if (this.isIndentEnabled()) {
            result.setBorder(new EmptyBorder(0, indent, 0, 0));
        }
        return result;
    }

    public void setIndentEnabled(boolean indent) {
        this.indentEnabled = indent;
    }

    public boolean isIndentEnabled() {
        return this.indentEnabled;
    }

    public void setNullText(String nullText) {
        this.nullText = nullText;
    }

    public String getNullText() {
        return this.nullText;
    }
}

