/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.datacleaner.util.SchemaComparator;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SchemaStructureComboBoxListRenderer;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceColumnComboBox
extends DCComboBox<Column> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SourceColumnComboBox.class);
    private final SchemaStructureComboBoxListRenderer _renderer = new SchemaStructureComboBoxListRenderer();
    private volatile DatastoreConnection _datastoreConnection;
    private volatile Table _table;

    public SourceColumnComboBox() {
        this.setRenderer(this._renderer);
        this.setEditable(false);
    }

    public SourceColumnComboBox(Datastore datastore) {
        this();
        this.setModel(datastore);
    }

    public SourceColumnComboBox(Datastore datastore, Table table) {
        this();
        this.setModel(datastore, table);
    }

    public void setEmptyModel() {
        this.setModel(null, null);
    }

    public void setModel(Datastore datastore, Table table) {
        Column previousItem = this.getSelectedItem();
        String previousColumnName = previousItem == null ? null : previousItem.getName();
        if (this.getTable() == table) {
            return;
        }
        this.setTable(table);
        if (datastore == null) {
            this.setDatastoreConnection(null);
        } else {
            this.setDatastoreConnection(datastore.openConnection());
        }
        if (table == null) {
            this.setModel(new DefaultComboBoxModel<String>(new String[1]));
        } else {
            Column[] columns;
            int selectedIndex = 0;
            ArrayList<Column> comboBoxList = new ArrayList<Column>();
            comboBoxList.add(null);
            for (Column column : columns = table.getColumns()) {
                comboBoxList.add(column);
                if (!column.getName().equals(previousColumnName)) continue;
                selectedIndex = comboBoxList.size() - 1;
            }
            ListComboBoxModel model = new ListComboBoxModel(comboBoxList);
            this.setModel(model);
            this.setSelectedIndex(selectedIndex);
        }
    }

    public void setModel(Datastore datastore) {
        this.setModel(datastore, true);
    }

    public void setModel(Table table) {
        this.setModel(null, table);
    }

    public void setModel(Datastore datastore, boolean retainSelection) {
        Column previousItem = this.getSelectedItem();
        this.setTable(null);
        if (datastore == null) {
            this.setDatastoreConnection(null);
            this.setModel(new DefaultComboBoxModel<String>(new String[1]));
        } else {
            DatastoreConnection con = this.setDatastoreConnection(datastore.openConnection());
            int selectedIndex = 0;
            ArrayList<Object> comboBoxList = new ArrayList<Object>();
            comboBoxList.add(null);
            Schema[] schemas = con.getSchemaNavigator().getSchemas();
            Arrays.sort(schemas, new SchemaComparator());
            for (Schema schema : schemas) {
                Table[] tables;
                comboBoxList.add(schema);
                if (SchemaComparator.isInformationSchema(schema)) continue;
                for (Table table : tables = schema.getTables()) {
                    try {
                        Column[] columns = table.getColumns();
                        if (columns == null || columns.length <= 0) continue;
                        comboBoxList.add(table);
                        for (Column column : columns) {
                            comboBoxList.add(column);
                            if (column != previousItem) continue;
                            selectedIndex = comboBoxList.size() - 1;
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error occurred getting columns of table: {}", (Object)table);
                    }
                }
            }
            ListComboBoxModel model = new ListComboBoxModel(comboBoxList);
            this.setModel(model);
            if (retainSelection) {
                this.setSelectedIndex(selectedIndex);
            }
        }
    }

    @Override
    public void setSelectedItem(Object value) {
        if (value instanceof String) {
            value = this._table == null ? null : this._table.getColumnByName((String)value);
        }
        super.setSelectedItem(value);
    }

    private void setTable(Table table) {
        this._table = table;
        this.setIndentation();
    }

    private void setIndentation() {
        this._renderer.setIndentEnabled(this._table == null && this._datastoreConnection != null);
    }

    public Table getTable() {
        return this._table;
    }

    private DatastoreConnection setDatastoreConnection(DatastoreConnection datastoreConnection) {
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
        this._datastoreConnection = datastoreConnection;
        this.setIndentation();
        return this._datastoreConnection;
    }

    @Override
    public Column getSelectedItem() {
        Object selectedItem = super.getSelectedItem();
        if (selectedItem instanceof Column) {
            return (Column)selectedItem;
        }
        return null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._datastoreConnection != null) {
            this._datastoreConnection.close();
        }
    }
}

