/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.SchemaFactory;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.EnumComboBoxListRenderer;
import org.eobjects.datacleaner.windows.TableDefinitionDialog;
import org.eobjects.metamodel.util.Action;
import org.eobjects.metamodel.util.HasName;
import org.eobjects.metamodel.util.SimpleTableDef;

public class TableDefinitionOptionSelectionPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final DCComboBox<TableDefinitionOption> _comboBox;
    private final JButton _configureButton;
    private final DCLabel _label;
    private final WindowContext _windowContext;
    private final Action<SimpleTableDef[]> _saveAction;
    private SimpleTableDef[] _tableDefs;

    public TableDefinitionOptionSelectionPanel(WindowContext windowContext, final SchemaFactory schemaFactory, SimpleTableDef[] tableDefs) {
        this._windowContext = windowContext;
        this._tableDefs = tableDefs;
        this._label = DCLabel.bright("Loading...");
        this._saveAction = new Action<SimpleTableDef[]>(){

            public void run(SimpleTableDef[] tableDefs) throws Exception {
                TableDefinitionOptionSelectionPanel.this.setTableDefs(tableDefs);
            }
        };
        this._comboBox = new DCComboBox<TableDefinitionOption>(TableDefinitionOption.values());
        this._comboBox.setRenderer(new EnumComboBoxListRenderer());
        this._configureButton = WidgetFactory.createSmallButton("images/menu/options.png");
        this._configureButton.setText("Define");
        this._configureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDefinitionDialog dialog = new TableDefinitionDialog(TableDefinitionOptionSelectionPanel.this._windowContext, schemaFactory, TableDefinitionOptionSelectionPanel.this._tableDefs, (Action<SimpleTableDef[]>)TableDefinitionOptionSelectionPanel.this._saveAction);
                dialog.setVisible(true);
            }
        });
        if (tableDefs != null && tableDefs.length > 0) {
            this._comboBox.setSelectedItem((Object)TableDefinitionOption.MANUAL);
        } else {
            this._comboBox.setSelectedItem((Object)TableDefinitionOption.AUTOMATIC);
        }
        this._comboBox.addListener(new DCComboBox.Listener<TableDefinitionOption>(){

            @Override
            public void onItemSelected(TableDefinitionOption item) {
                TableDefinitionOptionSelectionPanel.this.updateComponents();
            }
        });
        this.updateComponents();
        this.setLayout(new BorderLayout(4, 0));
        this.add(this._comboBox, "Center");
        this.add((Component)this._configureButton, "East");
        this.add((Component)this._label, "South");
    }

    private void updateComponents() {
        if (this._comboBox.getSelectedItem() == TableDefinitionOption.AUTOMATIC) {
            this._configureButton.setEnabled(false);
            this._label.setText("(Tables will be automatically discovered)");
        } else {
            this._configureButton.setEnabled(true);
            if (this._tableDefs == null || this._tableDefs.length == 0) {
                this._label.setText("(no tables defined)");
            } else {
                this._label.setText("(" + this._tableDefs.length + " tables defined)");
            }
        }
    }

    public SimpleTableDef[] getTableDefs() {
        if (this._comboBox.getSelectedItem() == TableDefinitionOption.AUTOMATIC) {
            return null;
        }
        return this._tableDefs;
    }

    public void setTableDefs(SimpleTableDef[] tableDefs) {
        this._tableDefs = tableDefs == null ? new SimpleTableDef[]{} : tableDefs;
        this.updateComponents();
    }

    public static enum TableDefinitionOption implements HasName
    {
        AUTOMATIC,
        MANUAL;


        public String getName() {
            if (this == AUTOMATIC) {
                return "Automatic discovery";
            }
            return "Manual definition";
        }
    }
}

