/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.database;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.database.DatabaseConnectionPresenter;
import org.jdesktop.swingx.JXTextField;

public abstract class AbstractDatabaseConnectionPresenter
implements DatabaseConnectionPresenter {
    private final JXTextField _usernameTextField = AbstractDatabaseConnectionPresenter.createTextField("Username");
    private final JPasswordField _passwordField = WidgetFactory.createPasswordField(30);

    protected static JXTextField createTextField(String promptText) {
        return WidgetFactory.createTextField(promptText, 30);
    }

    @Override
    public boolean initialize(JdbcDatastore datastore) {
        this._usernameTextField.setText(datastore.getUsername());
        this._passwordField.setText(datastore.getPassword());
        return true;
    }

    @Override
    public final JComponent getWidget() {
        DCPanel panel = new DCPanel();
        int row = this.layoutGridBagAboveCredentials(panel);
        WidgetUtils.addToGridBag(DCLabel.dark("Username:"), panel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._usernameTextField, (JPanel)panel, 1, row, 1.0, 0.0);
        WidgetUtils.addToGridBag(DCLabel.dark("Password:"), panel, 0, ++row);
        WidgetUtils.addToGridBag((Component)this._passwordField, (JPanel)panel, 1, row, 1.0, 0.0);
        this.layoutGridBagBelowCredentials(panel, row);
        return panel;
    }

    protected int layoutGridBagAboveCredentials(DCPanel panel) {
        return -1;
    }

    protected void layoutGridBagBelowCredentials(DCPanel panel, int row) {
    }

    public JXTextField getUsernameTextField() {
        return this._usernameTextField;
    }

    public JPasswordField getPasswordField() {
        return this._passwordField;
    }

    @Override
    public final String getUsername() {
        return this._usernameTextField.getText();
    }

    @Override
    public final String getPassword() {
        return new String(this._passwordField.getPassword());
    }
}

