/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.database;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.database.AbstractDatabaseConnectionPresenter;
import org.jdesktop.swingx.JXTextField;

public class DefaultDatabaseConnectionPresenter
extends AbstractDatabaseConnectionPresenter {
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final JXTextField _connectionStringTextField = WidgetFactory.createTextField("Connection string / URL", 30);
    private final JButton _connectionStringTemplateButton;
    private volatile String[] _connectionUrls;

    public DefaultDatabaseConnectionPresenter() {
        this._connectionStringTextField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "nextTemplateItem");
        this._connectionStringTextField.getActionMap().put("nextTemplateItem", this.getNextTemplateItemAction());
        this._connectionStringTemplateButton = new JButton(imageManager.getImageIcon("images/widgets/help.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        this._connectionStringTemplateButton.setMargin(new Insets(0, 0, 0, 0));
        this._connectionStringTemplateButton.setOpaque(false);
        this._connectionStringTemplateButton.setBorder(null);
        this._connectionStringTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultDatabaseConnectionPresenter.this._connectionUrls != null) {
                    JPopupMenu menu = new JPopupMenu();
                    for (final String connectionUrl : DefaultDatabaseConnectionPresenter.this._connectionUrls) {
                        JMenuItem menuItem = new JMenuItem(connectionUrl);
                        menuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DefaultDatabaseConnectionPresenter.this._connectionStringTextField.setText(connectionUrl);
                                DefaultDatabaseConnectionPresenter.this.getNextTemplateItemAction().actionPerformed(null);
                            }
                        });
                        menu.add(menuItem);
                    }
                    menu.show(DefaultDatabaseConnectionPresenter.this._connectionStringTemplateButton, 0, 0);
                }
            }
        });
    }

    @Override
    public boolean initialize(JdbcDatastore datastore) {
        super.initialize(datastore);
        this._connectionStringTextField.setText(datastore.getJdbcUrl());
        return true;
    }

    @Override
    protected int layoutGridBagAboveCredentials(DCPanel panel) {
        int row = 0;
        WidgetUtils.addToGridBag(DCLabel.dark("Connection string:"), panel, 0, row);
        WidgetUtils.addToGridBag((Component)this._connectionStringTextField, panel, 1, row);
        WidgetUtils.addToGridBag((Component)this._connectionStringTemplateButton, (JPanel)panel, 2, row, 1.0, 0.0);
        return row;
    }

    @Override
    public String getJdbcUrl() {
        return this._connectionStringTextField.getText();
    }

    private Action getNextTemplateItemAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectionEnd;
                String text = DefaultDatabaseConnectionPresenter.this._connectionStringTextField.getText();
                int selectionStart = text.indexOf(60, selectionEnd = DefaultDatabaseConnectionPresenter.this._connectionStringTextField.getSelectionEnd());
                if (selectionStart != -1) {
                    selectionEnd = text.indexOf(62, selectionStart);
                }
                if (selectionStart != -1 && selectionEnd != -1) {
                    DefaultDatabaseConnectionPresenter.this._connectionStringTextField.setSelectionStart(selectionStart);
                    DefaultDatabaseConnectionPresenter.this._connectionStringTextField.setSelectionEnd(selectionEnd + 1);
                    DefaultDatabaseConnectionPresenter.this._connectionStringTextField.requestFocus();
                } else {
                    selectionStart = text.indexOf(60);
                    if (selectionStart != -1) {
                        selectionEnd = text.indexOf(62, selectionStart);
                        if (selectionEnd != -1) {
                            DefaultDatabaseConnectionPresenter.this._connectionStringTextField.setSelectionStart(selectionStart);
                            DefaultDatabaseConnectionPresenter.this._connectionStringTextField.setSelectionEnd(selectionEnd + 1);
                            DefaultDatabaseConnectionPresenter.this._connectionStringTextField.requestFocus();
                        } else {
                            DefaultDatabaseConnectionPresenter.this.getUsernameTextField().requestFocus();
                        }
                    } else {
                        DefaultDatabaseConnectionPresenter.this.getUsernameTextField().requestFocus();
                    }
                }
                DefaultDatabaseConnectionPresenter.this._connectionStringTextField.getHorizontalVisibility().setValue(0);
            }
        };
    }

    @Override
    public void setSelectedDatabaseDriver(DatabaseDriverDescriptor driver) {
        if (driver == null) {
            this.setConnectionUrlTemplates(null);
        } else {
            String[] connectionUrls = driver.getConnectionUrlTemplates();
            this.setConnectionUrlTemplates(connectionUrls);
        }
    }

    private void setConnectionUrlTemplates(String[] connectionUrls) {
        this._connectionUrls = connectionUrls;
        boolean selectable = false;
        if (connectionUrls != null && connectionUrls.length > 0) {
            if (connectionUrls.length > 1) {
                selectable = true;
            }
            this._connectionStringTextField.setFocusTraversalKeysEnabled(false);
            String url = connectionUrls[0];
            this._connectionStringTextField.setText(url);
            this.getNextTemplateItemAction().actionPerformed(null);
        }
        this._connectionStringTemplateButton.setVisible(selectable);
    }
}

