/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.database;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.text.Document;
import org.eobjects.analyzer.connection.JdbcDatastore;
import org.eobjects.analyzer.util.HasGroupLiteral;
import org.eobjects.analyzer.util.NamedPattern;
import org.eobjects.analyzer.util.NamedPatternMatch;
import org.eobjects.datacleaner.database.DatabaseDriverDescriptor;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.database.AbstractDatabaseConnectionPresenter;
import org.jdesktop.swingx.JXTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlTemplateDatabaseConnectionPresenter
extends AbstractDatabaseConnectionPresenter {
    private static final Logger logger = LoggerFactory.getLogger(UrlTemplateDatabaseConnectionPresenter.class);
    private final JXTextField _hostnameTextField;
    private final JXTextField _portTextField;
    private final JXTextField _databaseTextField;
    private final JXTextField _param1TextField;
    private final JXTextField _param2TextField;
    private final JXTextField _param3TextField;
    private final JXTextField _param4TextField;
    private final List<NamedPattern<UrlPart>> _urlTemplates;

    public UrlTemplateDatabaseConnectionPresenter(String ... urlTemplates) {
        if (urlTemplates == null || urlTemplates.length == 0) {
            throw new IllegalArgumentException("URL templates cannot be null or empty");
        }
        this._urlTemplates = new ArrayList<NamedPattern<UrlPart>>(urlTemplates.length);
        for (String urlTemplate : urlTemplates) {
            NamedPattern template = new NamedPattern(urlTemplate, UrlPart.class);
            this._urlTemplates.add((NamedPattern<UrlPart>)template);
        }
        this._hostnameTextField = UrlTemplateDatabaseConnectionPresenter.createTextField("Hostname");
        this._hostnameTextField.setText("localhost");
        this._portTextField = UrlTemplateDatabaseConnectionPresenter.createTextField("Port");
        this._portTextField.setDocument((Document)new NumberDocument(false));
        this._portTextField.setText("" + this.getDefaultPort());
        this._databaseTextField = UrlTemplateDatabaseConnectionPresenter.createTextField(this.getLabelForDatabase());
        this._param1TextField = UrlTemplateDatabaseConnectionPresenter.createTextField(this.getLabelForParam1());
        this._param2TextField = UrlTemplateDatabaseConnectionPresenter.createTextField(this.getLabelForParam2());
        this._param3TextField = UrlTemplateDatabaseConnectionPresenter.createTextField(this.getLabelForParam3());
        this._param4TextField = UrlTemplateDatabaseConnectionPresenter.createTextField(this.getLabelForParam4());
    }

    protected String getLabelForDatabase() {
        return "Database";
    }

    protected String getLabelForParam1() {
        return "Parameter 1";
    }

    protected String getLabelForParam2() {
        return "Parameter 2";
    }

    protected String getLabelForParam3() {
        return "Parameter 3";
    }

    protected String getLabelForParam4() {
        return "Parameter 4";
    }

    protected abstract int getDefaultPort();

    @Override
    public final String getJdbcUrl() {
        String portText = this._portTextField.getText();
        int port = portText == null || portText.length() == 0 ? this.getDefaultPort() : Integer.parseInt(portText);
        return this.getJdbcUrl(this._hostnameTextField.getText(), port, this._databaseTextField.getText(), this._param1TextField.getText(), this._param2TextField.getText(), this._param3TextField.getText(), this._param4TextField.getText());
    }

    protected abstract String getJdbcUrl(String var1, int var2, String var3, String var4, String var5, String var6, String var7);

    @Override
    public boolean initialize(JdbcDatastore datastore) {
        super.initialize(datastore);
        String url = datastore.getJdbcUrl();
        NamedPatternMatch match = null;
        for (NamedPattern<UrlPart> urlTemplate : this._urlTemplates) {
            match = urlTemplate.match(url);
            if (match == null) continue;
            logger.info("URL '{}' matched with template: {}", (Object)url, urlTemplate);
            break;
        }
        if (match == null) {
            logger.info("Cannot handle jdbc url '{}', expected something to match: {}", (Object)url, this._urlTemplates);
            return false;
        }
        this._hostnameTextField.setText(match.get((Enum)UrlPart.HOSTNAME));
        this._portTextField.setText(match.get((Enum)UrlPart.PORT));
        this._databaseTextField.setText(match.get((Enum)UrlPart.DATABASE));
        this._param1TextField.setText(match.get((Enum)UrlPart.PARAM1));
        this._param2TextField.setText(match.get((Enum)UrlPart.PARAM2));
        this._param3TextField.setText(match.get((Enum)UrlPart.PARAM3));
        this._param4TextField.setText(match.get((Enum)UrlPart.PARAM4));
        return true;
    }

    @Override
    protected int layoutGridBagAboveCredentials(DCPanel panel) {
        EnumSet<UrlPart> urlParts = EnumSet.noneOf(UrlPart.class);
        for (NamedPattern<UrlPart> urlTemplate : this._urlTemplates) {
            urlParts.addAll(urlTemplate.getUsedGroups());
        }
        int row = -1;
        if (urlParts.contains((Object)UrlPart.HOSTNAME)) {
            WidgetUtils.addToGridBag(DCLabel.dark("Hostname:"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._hostnameTextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.PORT)) {
            WidgetUtils.addToGridBag(DCLabel.dark("Port:"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._portTextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.DATABASE)) {
            WidgetUtils.addToGridBag(DCLabel.dark(this.getLabelForDatabase() + ":"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._databaseTextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.PARAM1)) {
            WidgetUtils.addToGridBag(DCLabel.dark(this.getLabelForParam1() + ":"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._param1TextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.PARAM2)) {
            WidgetUtils.addToGridBag(DCLabel.dark(this.getLabelForParam2() + ":"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._param2TextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.PARAM3)) {
            WidgetUtils.addToGridBag(DCLabel.dark(this.getLabelForParam3() + ":"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._param3TextField, panel, 1, row);
        }
        if (urlParts.contains((Object)UrlPart.PARAM4)) {
            WidgetUtils.addToGridBag(DCLabel.dark(this.getLabelForParam4() + ":"), panel, 0, ++row);
            WidgetUtils.addToGridBag((Component)this._param4TextField, panel, 1, row);
        }
        return row;
    }

    @Override
    public void setSelectedDatabaseDriver(DatabaseDriverDescriptor driver) {
    }

    public static enum UrlPart implements HasGroupLiteral
    {
        HOSTNAME,
        PORT,
        DATABASE,
        PARAM1,
        PARAM2,
        PARAM3,
        PARAM4;


        public String getGroupLiteral() {
            if (this == PORT) {
                return "([0-9]+)";
            }
            return "(.+)";
        }
    }
}

