/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.VerticalLayout;

public abstract class AbstractMultipleCheckboxesPropertyWidget<E>
extends AbstractPropertyWidget<E[]> {
    private final DCCheckBox.Listener<E> CHANGE_LISTENER = new DCCheckBox.Listener<E>(){

        @Override
        public void onItemSelected(E item, boolean selected) {
            AbstractMultipleCheckboxesPropertyWidget.this.fireValueChanged();
        }
    };
    private final ActionListener SELECT_ALL_LISTENER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (DCCheckBox cb : AbstractMultipleCheckboxesPropertyWidget.this._checkBoxes.values()) {
                if (!cb.isEnabled()) continue;
                cb.setSelected(true);
            }
            AbstractMultipleCheckboxesPropertyWidget.this.fireValueChanged();
        }
    };
    private final ActionListener SELECT_NONE_LISTENER = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (DCCheckBox cb : AbstractMultipleCheckboxesPropertyWidget.this._checkBoxes.values()) {
                cb.setSelected(false);
            }
            AbstractMultipleCheckboxesPropertyWidget.this.fireValueChanged();
        }
    };
    private final Map<String, DCCheckBox<E>> _checkBoxes;
    private final Class<E> _itemClass;
    private final DCPanel _buttonPanel;
    private final DCCheckBox<E> _notAvailableCheckBox;

    public AbstractMultipleCheckboxesPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, Class<E> itemClass) {
        super(beanJobBuilder, propertyDescriptor);
        this._itemClass = itemClass;
        this._checkBoxes = new LinkedHashMap<String, DCCheckBox<E>>();
        this.setLayout((LayoutManager)new VerticalLayout(2));
        this._notAvailableCheckBox = new DCCheckBox(this.getNotAvailableText(), false);
        this._notAvailableCheckBox.setOpaque(false);
        this._notAvailableCheckBox.setEnabled(false);
        this._buttonPanel = this.createButtonPanel();
        this.add(this._buttonPanel);
    }

    private void updateVisibility() {
        this._buttonPanel.setVisible(this._checkBoxes.size() > 3);
        if (this._checkBoxes.isEmpty()) {
            this.add(this._notAvailableCheckBox);
        } else {
            this.remove(this._notAvailableCheckBox);
        }
    }

    protected DCPanel createButtonPanel() {
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setLayout((LayoutManager)new HorizontalLayout(2));
        JButton selectAllButton = new JButton("Select all");
        selectAllButton.addActionListener(this.SELECT_ALL_LISTENER);
        buttonPanel.add(selectAllButton);
        JButton selectNoneButton = new JButton("Select none");
        selectNoneButton.addActionListener(this.SELECT_NONE_LISTENER);
        buttonPanel.add(selectNoneButton);
        return buttonPanel;
    }

    @Override
    public void initialize(E[] values) {
        E[] availableValues;
        if (values != null) {
            for (E item : values) {
                this.addCheckBox(item, true);
            }
        }
        for (E item : availableValues = this.getAvailableValues()) {
            this.addCheckBox(item, this.isEnabled(item, values));
        }
        this.updateVisibility();
    }

    protected JCheckBox[] getCheckBoxes() {
        return this._checkBoxes.values().toArray(new JCheckBox[this._checkBoxes.size()]);
    }

    protected abstract E[] getAvailableValues();

    protected abstract String getNotAvailableText();

    protected JCheckBox addCheckBox(E item, boolean checked) {
        String name = this.getName(item);
        DCCheckBox<E> checkBox = this._checkBoxes.get(name);
        if (checkBox != null) {
            checkBox.setSelected(checked);
            return checkBox;
        }
        checkBox = new DCCheckBox(name, checked);
        checkBox.setValue(item);
        checkBox.setOpaque(false);
        checkBox.addListener(this.CHANGE_LISTENER);
        this._checkBoxes.put(name, checkBox);
        this.add(checkBox);
        this.updateVisibility();
        this.updateUI();
        return checkBox;
    }

    protected void removeCheckBox(E item) {
        DCCheckBox<E> checkBox = this._checkBoxes.remove(this.getName(item));
        if (checkBox != null) {
            this.remove(checkBox);
        }
        this.updateVisibility();
    }

    private boolean isEnabled(E value, E[] enabledValues) {
        if (enabledValues == null || enabledValues.length == 0) {
            return false;
        }
        for (E currentValue : enabledValues) {
            if (!currentValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSet() {
        for (JCheckBox checkBox : this.getCheckBoxes()) {
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public E[] getValue() {
        ArrayList<E> result = new ArrayList<E>();
        Collection<DCCheckBox<E>> checkBoxes = this._checkBoxes.values();
        for (DCCheckBox<E> cb : checkBoxes) {
            if (!cb.isSelected()) continue;
            result.add(cb.getValue());
        }
        Object[] array = (Object[])Array.newInstance(this._itemClass, result.size());
        return result.toArray(array);
    }

    @Override
    protected void setValue(E[] values) {
        if (this._checkBoxes.isEmpty() && values != null) {
            for (E value : values) {
                this.addCheckBox(value, true);
            }
        }
        for (DCCheckBox<E> cb : this._checkBoxes.values()) {
            if (ArrayUtils.contains((Object[])values, cb.getValue())) {
                cb.setSelected(true);
                continue;
            }
            cb.setSelected(false);
        }
        this.updateVisibility();
    }

    protected abstract String getName(E var1);
}

