/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public abstract class AbstractMultipleNumberPropertyWidget<N>
extends AbstractPropertyWidget<N> {
    private final NumberFormat _numberFormat = NumberFormat.getInstance();
    private final DCPanel _textFieldPanel = new DCPanel();

    protected AbstractMultipleNumberPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textFieldPanel.setLayout((LayoutManager)new VerticalLayout(2));
        Object currentValue = this.getCurrentValue();
        this.updateComponents(currentValue);
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMultipleNumberPropertyWidget.this.addTextField(null, true);
                AbstractMultipleNumberPropertyWidget.this.fireValueChanged();
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int componentCount = AbstractMultipleNumberPropertyWidget.this._textFieldPanel.getComponentCount();
                if (componentCount > 0) {
                    AbstractMultipleNumberPropertyWidget.this._textFieldPanel.remove(componentCount - 1);
                    AbstractMultipleNumberPropertyWidget.this._textFieldPanel.updateUI();
                    AbstractMultipleNumberPropertyWidget.this.fireValueChanged();
                }
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._textFieldPanel, "Center");
        outerPanel.add((Component)buttonPanel, "East");
        this.add(outerPanel);
    }

    private N createArray(int length) {
        return (N)Array.newInstance(this.getPropertyDescriptor().getBaseType(), length);
    }

    public void updateComponents(N values) {
        N previousValues;
        if (values == null) {
            values = this.createArray(2);
        }
        if (!EqualsBuilder.equals(values, previousValues = this.getValue())) {
            for (int i = 0; i < Math.min(Array.getLength(previousValues), Array.getLength(values)); ++i) {
                if (EqualsBuilder.equals((Object)Array.get(previousValues, i), (Object)Array.get(values, i))) continue;
                JTextComponent component = (JTextComponent)this._textFieldPanel.getComponent(i);
                component.setText(this._numberFormat.format(Array.get(values, i)));
            }
            while (this._textFieldPanel.getComponentCount() < Array.getLength(values)) {
                Object nextValue = Array.get(values, this._textFieldPanel.getComponentCount());
                this.addTextField(nextValue, false);
            }
            while (this._textFieldPanel.getComponentCount() > Array.getLength(values)) {
                this._textFieldPanel.remove(this._textFieldPanel.getComponentCount() - 1);
            }
            this._textFieldPanel.updateUI();
        }
    }

    private void addTextField(Object value, boolean updateUI) {
        JXTextField textField = WidgetFactory.createTextField();
        if (value != null) {
            textField.setText(this._numberFormat.format(value));
        }
        textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                AbstractMultipleNumberPropertyWidget.this.fireValueChanged();
            }
        });
        this._textFieldPanel.add((Component)textField);
        if (updateUI) {
            this._textFieldPanel.updateUI();
        }
    }

    @Override
    public N getValue() {
        Component[] components = this._textFieldPanel.getComponents();
        N result = this.createArray(components.length);
        for (int i = 0; i < components.length; ++i) {
            JXTextField textField = (JXTextField)components[i];
            String stringValue = textField.getText();
            this.setInArray(result, i, this.convertToNumber(stringValue));
        }
        return result;
    }

    private void setInArray(Object array, int index, Number number) {
        Class baseType = this.getPropertyDescriptor().getBaseType();
        if (baseType.isPrimitive()) {
            if (number == null) {
                number = 0;
            }
            if (baseType == Byte.TYPE) {
                Array.setByte(array, index, number.byteValue());
            } else if (baseType == Short.TYPE) {
                Array.setShort(array, index, number.shortValue());
            } else if (baseType == Integer.TYPE) {
                Array.setInt(array, index, number.intValue());
            } else if (baseType == Long.TYPE) {
                Array.setLong(array, index, number.longValue());
            } else if (baseType == Float.TYPE) {
                Array.setFloat(array, index, number.floatValue());
            } else if (baseType == Double.TYPE) {
                Array.setDouble(array, index, number.doubleValue());
            }
        } else {
            Array.set(array, index, number);
        }
    }

    private Number convertToNumber(String stringValue) {
        if (StringUtils.isNullOrEmpty((String)stringValue)) {
            return null;
        }
        Class type = this.getPropertyDescriptor().getBaseType();
        try {
            Number number = this._numberFormat.parse(stringValue);
            if (type != Number.class) {
                if (ReflectionUtils.isInteger((Type)type)) {
                    return number.intValue();
                }
                if (ReflectionUtils.isLong((Type)type)) {
                    return number.longValue();
                }
                if (ReflectionUtils.isDouble((Type)type)) {
                    return number.doubleValue();
                }
                if (ReflectionUtils.isShort((Type)type)) {
                    return number.shortValue();
                }
                if (ReflectionUtils.isByte((Type)type)) {
                    return number.byteValue();
                }
                if (ReflectionUtils.isFloat((Type)type)) {
                    return Float.valueOf(number.floatValue());
                }
            }
            return number;
        }
        catch (ParseException e) {
            throw new IllegalStateException("Cannot parse to number: " + stringValue);
        }
    }

    @Override
    protected void setValue(N value) {
        this.updateComponents(value);
    }
}

