/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.properties.MinimalPropertyWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyWidget<E>
extends MinimalPropertyWidget<E> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPropertyWidget.class);
    private final DCPanel _panel = new DCPanel(){
        private static final long serialVersionUID = 1L;

        @Override
        public void addNotify() {
            super.addNotify();
            AbstractPropertyWidget.this.onPanelAdd();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            AbstractPropertyWidget.this.onPanelRemove();
        }
    };
    private volatile int _batchUpdateCounter = 0;

    public AbstractPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this.setLayout(new GridLayout(1, 1));
    }

    public final void batchUpdateWidget(Runnable action) {
        ++this._batchUpdateCounter;
        try {
            action.run();
        }
        catch (Exception e) {
            logger.error("Exception occurred in widget batch update, fireValueChanged() will not be invoked", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
        finally {
            --this._batchUpdateCounter;
        }
        if (this._batchUpdateCounter == 0) {
            this.onBatchFinished();
        }
    }

    protected void onBatchFinished() {
        this.fireValueChanged();
    }

    public final boolean isBatchUpdating() {
        return this._batchUpdateCounter > 0;
    }

    protected void setLayout(LayoutManager layout) {
        this._panel.setLayout(layout);
    }

    protected void removeAll() {
        this._panel.removeAll();
    }

    @Deprecated
    protected void removeNotify() {
    }

    @Deprecated
    protected void addNotify() {
    }

    protected void onPanelAdd() {
        this.addNotify();
    }

    protected void onPanelRemove() {
        this.removeNotify();
    }

    protected void add(Component component, int index) {
        this._panel.add(component, index);
    }

    protected Component[] getComponents() {
        return this._panel.getComponents();
    }

    protected void add(Component component) {
        this._panel.add(component);
    }

    protected void add(Component component, Object constraints) {
        this._panel.add(component, constraints);
    }

    protected void remove(Component component) {
        this._panel.remove(component);
    }

    protected void updateUI() {
        this._panel.updateUI();
    }

    protected void setBorder(Border border) {
        this._panel.setBorder(border);
    }

    @Override
    public final JComponent getWidget() {
        return this._panel;
    }
}

