/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MinimalPropertyWidget<E>
implements PropertyWidget<E> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPropertyWidget.class);
    private final AbstractBeanJobBuilder<?, ?, ?> _beanJobBuilder;
    private final ConfiguredPropertyDescriptor _propertyDescriptor;
    private volatile transient int _updating;

    public MinimalPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        this._beanJobBuilder = beanJobBuilder;
        this._propertyDescriptor = propertyDescriptor;
        this._updating = 0;
    }

    @Override
    public void initialize(E value) {
    }

    @Override
    public final ConfiguredPropertyDescriptor getPropertyDescriptor() {
        return this._propertyDescriptor;
    }

    public final AbstractBeanJobBuilder<?, ?, ?> getBeanJobBuilder() {
        return this._beanJobBuilder;
    }

    @Override
    public boolean isSet() {
        return this.getValue() != null;
    }

    public final void fireValueChanged() {
        Object value = this.getValue();
        this.fireValueChanged(value);
    }

    protected ActionListener fireValueChangedActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinimalPropertyWidget.this.fireValueChanged();
            }
        };
    }

    protected final AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._beanJobBuilder.getAnalysisJobBuilder();
    }

    @Override
    public void onValueTouched(E value) {
        if (this.isUpdating()) {
            return;
        }
        Object existingValue = this.getValue();
        if (EqualsBuilder.equals(value, existingValue)) {
            return;
        }
        this.setValue(value);
    }

    protected boolean isUpdating() {
        return this._updating > 0;
    }

    protected void setUpdating(boolean updating) {
        if (updating) {
            ++this._updating;
        } else {
            assert (this._updating > 0);
            --this._updating;
        }
    }

    protected E getCurrentValue() {
        return (E)this.getBeanJobBuilder().getConfiguredProperty(this.getPropertyDescriptor());
    }

    protected abstract void setValue(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireValueChanged(Object newValue) {
        this.setUpdating(true);
        try {
            this._beanJobBuilder.setConfiguredProperty(this._propertyDescriptor, newValue);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Exception thrown when setting configured property " + this._propertyDescriptor, (Throwable)e);
            }
        }
        finally {
            this.setUpdating(false);
        }
    }
}

