/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.CharTextField;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.VerticalLayout;

public class MultipleCharPropertyWidget
extends AbstractPropertyWidget<char[]> {
    private final DCPanel _textFieldPanel = new DCPanel();

    @Inject
    public MultipleCharPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textFieldPanel.setLayout((LayoutManager)new VerticalLayout(2));
        char[] currentValue = (char[])this.getCurrentValue();
        if (currentValue == null) {
            currentValue = new char[1];
        }
        this.updateComponents(currentValue);
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCharPropertyWidget.this.addCharField();
                MultipleCharPropertyWidget.this.fireValueChanged();
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int componentCount = MultipleCharPropertyWidget.this._textFieldPanel.getComponentCount();
                if (componentCount > 0) {
                    MultipleCharPropertyWidget.this._textFieldPanel.remove(componentCount - 1);
                    MultipleCharPropertyWidget.this._textFieldPanel.updateUI();
                    MultipleCharPropertyWidget.this.fireValueChanged();
                }
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._textFieldPanel, "Center");
        outerPanel.add((Component)buttonPanel, "East");
        this.add(outerPanel);
    }

    public void updateComponents(char[] values) {
        this._textFieldPanel.removeAll();
        if (values != null) {
            for (char value : values) {
                this.addTextComponent(value);
            }
        }
    }

    private CharTextField addCharField() {
        CharTextField textField = new CharTextField();
        textField.addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                MultipleCharPropertyWidget.this.fireValueChanged();
            }
        });
        this._textFieldPanel.add(textField);
        this._textFieldPanel.updateUI();
        return textField;
    }

    private void addTextComponent(char value) {
        this.addCharField().setValue(Character.valueOf(value));
    }

    @Override
    public char[] getValue() {
        Component[] components = this._textFieldPanel.getComponents();
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < components.length; ++i) {
            DCPanel panel = (DCPanel)components[i];
            JTextComponent textComponent = (JTextComponent)panel.getComponent(0);
            String text = textComponent.getText();
            if (text == null || text.length() != 1) continue;
            list.add(Character.valueOf(text.charAt(0)));
        }
        char[] result = new char[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Character)list.get(i)).charValue();
        }
        return result;
    }

    @Override
    protected void setValue(char[] value) {
        this.updateComponents(value);
    }
}

