/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.DictionaryChangeListener;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractMultipleCheckboxesPropertyWidget;
import org.eobjects.datacleaner.windows.ReferenceDataDialog;

public class MultipleDictionariesPropertyWidget
extends AbstractMultipleCheckboxesPropertyWidget<Dictionary>
implements DictionaryChangeListener {
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private Provider<ReferenceDataDialog> _referenceDataDialogProvider;

    @Inject
    public MultipleDictionariesPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, MutableReferenceDataCatalog referenceDataCatalog, Provider<ReferenceDataDialog> referenceDataDialogProvider) {
        super(beanJobBuilder, propertyDescriptor, Dictionary.class);
        this._referenceDataCatalog = referenceDataCatalog;
        this._referenceDataDialogProvider = referenceDataDialogProvider;
    }

    @Override
    public void onPanelAdd() {
        super.onPanelAdd();
        this._referenceDataCatalog.addDictionaryListener(this);
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._referenceDataCatalog.removeDictionaryListener(this);
    }

    @Override
    protected DCPanel createButtonPanel() {
        DCPanel buttonPanel = super.createButtonPanel();
        JButton dialogButton = WidgetFactory.createSmallButton("images/menu/options.png");
        dialogButton.setToolTipText("Configure dictionaries");
        dialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog dialog = (ReferenceDataDialog)MultipleDictionariesPropertyWidget.this._referenceDataDialogProvider.get();
                dialog.selectDictionariesTab();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(dialogButton);
        return buttonPanel;
    }

    protected Dictionary[] getAvailableValues() {
        String[] names = this._referenceDataCatalog.getDictionaryNames();
        Dictionary[] result = new Dictionary[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this._referenceDataCatalog.getDictionary(names[i]);
        }
        return result;
    }

    @Override
    protected String getName(Dictionary item) {
        return item.getName();
    }

    @Override
    public void onAdd(Dictionary dictionary) {
        this.addCheckBox(dictionary, false);
    }

    @Override
    public void onRemove(Dictionary dictionary) {
        this.removeCheckBox(dictionary);
    }

    @Override
    protected String getNotAvailableText() {
        return "- no dictionaries available -";
    }
}

