/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.ArrayUtils;
import org.eobjects.analyzer.data.ExpressionBasedInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.actions.AddExpressionBasedColumnActionListener;
import org.eobjects.datacleaner.actions.ReorderColumnsActionListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class MultipleInputColumnsPropertyWidget
extends AbstractPropertyWidget<InputColumn<?>[]>
implements SourceColumnChangeListener,
TransformerChangeListener {
    private static final EmptyBorder _indentBorder = new MatteBorder(1, 17, 0, 1, WidgetUtils.BG_COLOR_BRIGHT);
    private final DCCheckBox.Listener<InputColumn<?>> checkBoxListener = new DCCheckBox.Listener<InputColumn<?>>(){

        @Override
        public void onItemSelected(InputColumn<?> item, boolean selected) {
            if (MultipleInputColumnsPropertyWidget.this.isBatchUpdating()) {
                return;
            }
            MultipleInputColumnsPropertyWidget.this.fireValueChanged();
        }
    };
    private final ActionListener selectAllActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleInputColumnsPropertyWidget.this.selectAll();
        }
    };
    private final ActionListener selectNoneActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleInputColumnsPropertyWidget.this.selectNone();
        }
    };
    private final Class<?> _dataType;
    private final Map<InputColumn<?>, DCCheckBox<InputColumn<?>>> _checkBoxes;
    private final Map<DCCheckBox<InputColumn<?>>, JComponent> _checkBoxDecorations;
    private final DCPanel _buttonPanel;
    private final JXTextField _searchDatastoreTextField;
    private final DCCheckBox<InputColumn<?>> _notAvailableCheckBox;
    private volatile boolean _firstUpdate;

    @Inject
    public MultipleInputColumnsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this.setBorder(new EtchedBorder(1));
        this._checkBoxes = new LinkedHashMap();
        this._checkBoxDecorations = new IdentityHashMap();
        this._firstUpdate = true;
        this._dataType = propertyDescriptor.getTypeArgument(0);
        this.getAnalysisJobBuilder().getSourceColumnListeners().add(this);
        this.getAnalysisJobBuilder().getTransformerChangeListeners().add(this);
        this.setLayout((LayoutManager)new VerticalLayout(2));
        this._searchDatastoreTextField = WidgetFactory.createTextField("Search/filter columns");
        this._searchDatastoreTextField.setBorder((Border)new CompoundBorder(_indentBorder, WidgetUtils.BORDER_THIN));
        this._searchDatastoreTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                String text = MultipleInputColumnsPropertyWidget.this._searchDatastoreTextField.getText();
                if (StringUtils.isNullOrEmpty((String)text)) {
                    for (DCCheckBox cb : MultipleInputColumnsPropertyWidget.this._checkBoxes.values()) {
                        cb.setVisible(true);
                    }
                } else {
                    text = text.trim().toLowerCase();
                    Iterator i$ = MultipleInputColumnsPropertyWidget.this._checkBoxes.values().iterator();
                    while (i$.hasNext()) {
                        DCCheckBox cb;
                        String name = (cb = (DCCheckBox)i$.next()).getText().toLowerCase();
                        cb.setVisible(name.indexOf(text) != -1);
                    }
                }
            }
        });
        this._notAvailableCheckBox = new DCCheckBox("<html><font color=\"gray\">- no <i>" + LabelUtils.getDataTypeLabel(this._dataType) + "</i> columns available -</font></html>", false);
        this._notAvailableCheckBox.setEnabled(false);
        this._buttonPanel = new DCPanel();
        this._buttonPanel.setLayout((LayoutManager)new HorizontalLayout(2));
        this._buttonPanel.setBorder(_indentBorder);
        JButton selectAllButton = new JButton("Select all");
        selectAllButton.setFont(WidgetUtils.FONT_SMALL);
        selectAllButton.addActionListener(this.selectAllActionListener);
        this._buttonPanel.add(selectAllButton);
        JButton selectNoneButton = new JButton("Select none");
        selectNoneButton.setFont(WidgetUtils.FONT_SMALL);
        selectNoneButton.addActionListener(this.selectNoneActionListener);
        this._buttonPanel.add(selectNoneButton);
        if (propertyDescriptor.isArray()) {
            if (this._dataType == String.class || this._dataType == Object.class) {
                JButton expressionColumnButton = WidgetFactory.createSmallButton("images/model/column_expression.png");
                expressionColumnButton.setToolTipText("Create expression/value based column");
                expressionColumnButton.addActionListener(AddExpressionBasedColumnActionListener.forMultipleColumns(this));
                this._buttonPanel.add(expressionColumnButton);
            }
            JButton reorderColumnsButton = WidgetFactory.createSmallButton("images/actions/reorder-columns.png");
            reorderColumnsButton.setToolTipText("Reorder columns");
            reorderColumnsButton.addActionListener(new ReorderColumnsActionListener(this));
            this._buttonPanel.add(reorderColumnsButton);
        }
        this.add(this._buttonPanel);
        this.add((Component)this._searchDatastoreTextField);
    }

    @Override
    public void initialize(InputColumn<?>[] value) {
        this.updateComponents(value);
        this._firstUpdate = false;
        if (value != null && value.length > 0) {
            this.reorderValue(value);
        }
    }

    protected boolean isAllInputColumnsSelectedIfNoValueExist() {
        AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder = this.getBeanJobBuilder();
        return beanJobBuilder instanceof AnalyzerJobBuilder;
    }

    private void updateComponents(InputColumn<?>[] value) {
        List availableColumns = this.getAnalysisJobBuilder().getAvailableInputColumns(this._dataType);
        if (this.getBeanJobBuilder() instanceof TransformerJobBuilder) {
            TransformerJobBuilder tjb = (TransformerJobBuilder)this.getBeanJobBuilder();
            List outputColumns = tjb.getOutputColumns();
            availableColumns.removeAll(outputColumns);
        }
        HashSet inputColumnsToBeRemoved = new HashSet();
        inputColumnsToBeRemoved.addAll(this._checkBoxes.keySet());
        if (value != null) {
            for (InputColumn<?> col : value) {
                if (!(col instanceof ExpressionBasedInputColumn)) continue;
                inputColumnsToBeRemoved.remove(col);
                availableColumns.add(col);
            }
        }
        for (InputColumn inputColumn : availableColumns) {
            inputColumnsToBeRemoved.remove(inputColumn);
            DCCheckBox<InputColumn<?>> checkBox = this._checkBoxes.get(inputColumn);
            if (checkBox == null) {
                this.addAvailableInputColumn(inputColumn, this.isEnabled(inputColumn, value));
                continue;
            }
            checkBox.setText(inputColumn.getName());
        }
        for (InputColumn inputColumn : inputColumnsToBeRemoved) {
            this.removeAvailableInputColumn(inputColumn);
        }
        this.updateVisibility();
        this.fireValueChanged();
    }

    private void updateVisibility() {
        this._searchDatastoreTextField.setVisible(this._checkBoxes.size() > 5);
        if (this._checkBoxes.isEmpty()) {
            this.add(this._notAvailableCheckBox);
        } else {
            this.remove(this._notAvailableCheckBox);
        }
    }

    protected JComponent decorateCheckBox(DCCheckBox<InputColumn<?>> checkBox) {
        return checkBox;
    }

    private boolean isEnabled(InputColumn<?> inputColumn, InputColumn<?>[] currentValue) {
        if (this._firstUpdate && (currentValue == null || currentValue.length == 0)) {
            ComponentDescriptor componentDescriptor = this.getPropertyDescriptor().getComponentDescriptor();
            if (componentDescriptor instanceof BeanDescriptor && ((BeanDescriptor)componentDescriptor).getConfiguredPropertiesForInput(false).size() == 1) {
                return this.isAllInputColumnsSelectedIfNoValueExist();
            }
            return false;
        }
        for (InputColumn<?> col : currentValue) {
            if (inputColumn != col) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSet() {
        for (DCCheckBox<InputColumn<?>> checkBox : this._checkBoxes.values()) {
            if (!checkBox.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputColumn<?>[] getValue() {
        ArrayList result = new ArrayList();
        Collection<DCCheckBox<InputColumn<?>>> checkBoxes = this._checkBoxes.values();
        for (DCCheckBox<InputColumn<?>> cb : checkBoxes) {
            InputColumn<?> value;
            if (!cb.isSelected() || (value = cb.getValue()) == null) continue;
            result.add(value);
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        if (this._dataType == Object.class || ReflectionUtils.is((Type)sourceColumn.getDataType(), this._dataType)) {
            this.addAvailableInputColumn(sourceColumn);
            this.updateVisibility();
        }
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        this.removeAvailableInputColumn(sourceColumn);
        this.updateVisibility();
    }

    public void onAdd(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onOutputChanged(TransformerJobBuilder<?> transformerJobBuilder, List<MutableInputColumn<?>> outputColumns) {
        InputColumn<?>[] value = this.getValue();
        this.getBeanJobBuilder().setConfiguredProperty(this.getPropertyDescriptor(), value);
        this.updateComponents(value);
    }

    public void onRemove(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this.getAnalysisJobBuilder().getSourceColumnListeners().remove(this);
    }

    public void onConfigurationChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onRequirementChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    @Override
    protected void setValue(InputColumn<?>[] values) {
        if (this._checkBoxes.isEmpty()) {
            for (InputColumn<?> value : values) {
                this.addAvailableInputColumn(value, true);
            }
        }
        for (InputColumn<?> inputColumn : values) {
            if (!(inputColumn instanceof ExpressionBasedInputColumn) || this._checkBoxes.containsKey(inputColumn)) continue;
            this.addAvailableInputColumn(inputColumn, true);
        }
        for (DCCheckBox<InputColumn<?>> cb : this._checkBoxes.values()) {
            if (ArrayUtils.contains((Object[])values, cb.getValue())) {
                cb.setSelected(true);
                continue;
            }
            cb.setSelected(false);
        }
        this.updateUI();
    }

    protected void selectAll() {
        this.batchUpdateWidget(new Runnable(){

            @Override
            public void run() {
                for (DCCheckBox cb : MultipleInputColumnsPropertyWidget.this._checkBoxes.values()) {
                    if (!cb.isEnabled()) continue;
                    cb.setSelected(true);
                }
            }
        });
    }

    protected void selectNone() {
        this.batchUpdateWidget(new Runnable(){

            @Override
            public void run() {
                for (DCCheckBox cb : MultipleInputColumnsPropertyWidget.this._checkBoxes.values()) {
                    cb.setSelected(false);
                }
            }
        });
    }

    private void addAvailableInputColumn(InputColumn<?> col) {
        this.addAvailableInputColumn(col, false);
    }

    private void addAvailableInputColumn(InputColumn<?> col, boolean selected) {
        String name = col.getName();
        DCCheckBox cb = new DCCheckBox(name, selected);
        cb.addListener(this.checkBoxListener);
        cb.setValue(col);
        this._checkBoxes.put(col, cb);
        JComponent decoration = this.decorateCheckBox(cb);
        this._checkBoxDecorations.put(cb, decoration);
        this.add(decoration);
    }

    private void removeAvailableInputColumn(InputColumn<?> col) {
        boolean valueChanged = false;
        DCCheckBox<InputColumn<?>> checkBox = this._checkBoxes.remove(col);
        if (checkBox != null) {
            if (checkBox.isSelected()) {
                valueChanged = true;
            }
            JComponent decoration = this._checkBoxDecorations.remove(checkBox);
            this.remove(decoration);
        }
        if (valueChanged) {
            this.fireValueChanged();
        }
    }

    public void reorderValue(InputColumn<?>[] sortedValue) {
        int offset = 2;
        for (int i = 0; i < sortedValue.length; ++i) {
            InputColumn<?> inputColumn = sortedValue[i];
            DCCheckBox<InputColumn<?>> checkBox = this._checkBoxes.get(inputColumn);
            JComponent decoration = this._checkBoxDecorations.get(checkBox);
            this.add((Component)decoration, i + 2);
        }
        this.updateUI();
        TreeMap checkBoxesCopy = new TreeMap(this._checkBoxes);
        this._checkBoxes.clear();
        for (InputColumn<?> inputColumn : sortedValue) {
            this._checkBoxes.put(inputColumn, checkBoxesCopy.get(inputColumn));
        }
        this._checkBoxes.putAll(checkBoxesCopy);
    }

    public Map<InputColumn<?>, DCCheckBox<InputColumn<?>>> getCheckBoxes() {
        return Collections.unmodifiableMap(this._checkBoxes);
    }

    public Map<DCCheckBox<InputColumn<?>>, JComponent> getCheckBoxDecorations() {
        return Collections.unmodifiableMap(this._checkBoxDecorations);
    }

    public DCPanel getButtonPanel() {
        return this._buttonPanel;
    }
}

