/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SourceColumnComboBox;
import org.eobjects.datacleaner.widgets.properties.MinimalPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleInputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.eobjects.metamodel.util.MutableRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleMappedColumnsPropertyWidget
extends MultipleInputColumnsPropertyWidget {
    private static final Logger logger = LoggerFactory.getLogger(MultipleMappedColumnsPropertyWidget.class);
    private final WeakHashMap<InputColumn<?>, SourceColumnComboBox> _mappedColumnComboBoxes = new WeakHashMap();
    private final MutableRef<Table> _tableRef;
    private final ConfiguredPropertyDescriptor _mappedColumnsProperty;
    private final MinimalPropertyWidget<String[]> _mappedColumnNamesPropertyWidget;
    private volatile boolean _sourceColumnUpdating;

    public MultipleMappedColumnsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor inputColumnsProperty, ConfiguredPropertyDescriptor mappedColumnsProperty) {
        super(beanJobBuilder, inputColumnsProperty);
        this._mappedColumnsProperty = mappedColumnsProperty;
        this._tableRef = new MutableRef();
        this._mappedColumnNamesPropertyWidget = this.createMappedColumnNamesPropertyWidget();
        this._sourceColumnUpdating = false;
        InputColumn[] currentValue = (InputColumn[])this.getCurrentValue();
        String[] currentMappedColumnsValue = (String[])beanJobBuilder.getConfiguredProperty(mappedColumnsProperty);
        if (currentValue != null && currentMappedColumnsValue != null) {
            this._mappedColumnNamesPropertyWidget.setValue(currentMappedColumnsValue);
            int minLength = Math.min(currentValue.length, currentMappedColumnsValue.length);
            for (int i = 0; i < minLength; ++i) {
                InputColumn inputColumn = currentValue[i];
                String mappedColumnName = currentMappedColumnsValue[i];
                this.createComboBox(inputColumn, (Column)new MutableColumn(mappedColumnName));
            }
            this.setValue(currentValue);
        }
    }

    public void setTable(Table table) {
        if (table != this._tableRef.get()) {
            this._tableRef.set((Object)table);
            this.updateMappedColumns();
        }
    }

    private void updateMappedColumns() {
        final Table table = (Table)this._tableRef.get();
        final Set<Map.Entry<InputColumn<?>, SourceColumnComboBox>> entrySet = this._mappedColumnComboBoxes.entrySet();
        this.batchUpdateWidget(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : entrySet) {
                    Column column;
                    InputColumn inputColumn = (InputColumn)entry.getKey();
                    SourceColumnComboBox comboBox = (SourceColumnComboBox)entry.getValue();
                    if (table == null) {
                        comboBox.setEmptyModel();
                        continue;
                    }
                    comboBox.setModel(table);
                    if (comboBox.getSelectedItem() != null || (column = MultipleMappedColumnsPropertyWidget.this.getDefaultMappedColumn(inputColumn, table)) == null) continue;
                    comboBox.setEditable(true);
                    comboBox.setSelectedItem(column);
                    comboBox.setEditable(false);
                }
            }
        });
    }

    @Override
    protected boolean isAllInputColumnsSelectedIfNoValueExist() {
        return false;
    }

    private SourceColumnComboBox createComboBox(InputColumn<?> inputColumn, Column mappedColumn) {
        SourceColumnComboBox sourceColumnComboBox = new SourceColumnComboBox();
        this._mappedColumnComboBoxes.put(inputColumn, sourceColumnComboBox);
        Table table = (Table)this._tableRef.get();
        if (mappedColumn == null && table != null) {
            mappedColumn = this.getDefaultMappedColumn(inputColumn, table);
        }
        if (mappedColumn == null) {
            logger.info("No default mapping found for column: {}", inputColumn);
        } else {
            sourceColumnComboBox.setEditable(true);
            sourceColumnComboBox.setSelectedItem(mappedColumn);
            sourceColumnComboBox.setEditable(false);
        }
        sourceColumnComboBox.addListener(new DCComboBox.Listener<Column>(){

            @Override
            public void onItemSelected(Column item) {
                if (MultipleMappedColumnsPropertyWidget.this.isBatchUpdating()) {
                    return;
                }
                MultipleMappedColumnsPropertyWidget.this._sourceColumnUpdating = true;
                MultipleMappedColumnsPropertyWidget.this.fireValueChanged();
                MultipleMappedColumnsPropertyWidget.this._mappedColumnNamesPropertyWidget.fireValueChanged();
                MultipleMappedColumnsPropertyWidget.this._sourceColumnUpdating = false;
            }
        });
        return sourceColumnComboBox;
    }

    protected Column getDefaultMappedColumn(InputColumn<?> inputColumn, Table table) {
        return table.getColumnByName(inputColumn.getName());
    }

    @Override
    protected JComponent decorateCheckBox(DCCheckBox<InputColumn<?>> checkBox) {
        InputColumn<?> inputColumn = checkBox.getValue();
        SourceColumnComboBox sourceColumnComboBox = this._mappedColumnComboBoxes.containsKey(inputColumn) ? this._mappedColumnComboBoxes.get(inputColumn) : this.createComboBox(inputColumn, null);
        final JComponent decoratedSourceColumnComboBox = this.decorateSourceColumnComboBox(inputColumn, sourceColumnComboBox);
        checkBox.addListenerToHead(new DCCheckBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item, boolean selected) {
                MultipleMappedColumnsPropertyWidget.this._sourceColumnUpdating = true;
                decoratedSourceColumnComboBox.setVisible(selected);
            }
        });
        checkBox.addListener(new DCCheckBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item, boolean selected) {
                if (MultipleMappedColumnsPropertyWidget.this.isBatchUpdating()) {
                    return;
                }
                MultipleMappedColumnsPropertyWidget.this._mappedColumnNamesPropertyWidget.fireValueChanged();
                MultipleMappedColumnsPropertyWidget.this._sourceColumnUpdating = false;
            }
        });
        Table table = (Table)this._tableRef.get();
        if (table != null) {
            sourceColumnComboBox.setModel(table);
        }
        decoratedSourceColumnComboBox.setVisible(checkBox.isSelected());
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add(checkBox, "Center");
        panel.add((Component)decoratedSourceColumnComboBox, "East");
        return panel;
    }

    protected JComponent decorateSourceColumnComboBox(InputColumn<?> inputColumn, SourceColumnComboBox sourceColumnComboBox) {
        return sourceColumnComboBox;
    }

    public PropertyWidget<String[]> getMappedColumnNamesPropertyWidget() {
        return this._mappedColumnNamesPropertyWidget;
    }

    private MinimalPropertyWidget<String[]> createMappedColumnNamesPropertyWidget() {
        return new MinimalPropertyWidget<String[]>(this.getBeanJobBuilder(), this._mappedColumnsProperty){

            @Override
            public JComponent getWidget() {
                return null;
            }

            @Override
            public boolean isSet() {
                InputColumn<?>[] inputColumns;
                for (InputColumn<?> inputColumn : inputColumns = MultipleMappedColumnsPropertyWidget.this.getValue()) {
                    SourceColumnComboBox comboBox = (SourceColumnComboBox)MultipleMappedColumnsPropertyWidget.this._mappedColumnComboBoxes.get(inputColumn);
                    if (comboBox.getSelectedItem() != null) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String[] getValue() {
                return MultipleMappedColumnsPropertyWidget.this.getMappedColumnNames();
            }

            @Override
            protected void setValue(String[] value) {
                if (MultipleMappedColumnsPropertyWidget.this._sourceColumnUpdating) {
                    return;
                }
                if (EqualsBuilder.equals((Object)value, (Object)this.getValue())) {
                    return;
                }
                InputColumn<?>[] inputColumns = MultipleMappedColumnsPropertyWidget.this.getValue();
                for (int i = 0; i < inputColumns.length; ++i) {
                    InputColumn<?> inputColumn = inputColumns[i];
                    String mappedColumnName = value == null ? null : (i < value.length ? value[i] : null);
                    SourceColumnComboBox comboBox = (SourceColumnComboBox)MultipleMappedColumnsPropertyWidget.this._mappedColumnComboBoxes.get(inputColumn);
                    comboBox.setEditable(true);
                    comboBox.setSelectedItem(mappedColumnName);
                    comboBox.setEditable(false);
                }
            }
        };
    }

    @Override
    public InputColumn<?>[] getValue() {
        InputColumn<?>[] checkedInputColumns = super.getValue();
        ArrayList result = new ArrayList();
        for (InputColumn<?> inputColumn : checkedInputColumns) {
            SourceColumnComboBox comboBox = this._mappedColumnComboBoxes.get(inputColumn);
            if (comboBox == null || comboBox.getSelectedItem() == null) continue;
            result.add(inputColumn);
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    private String[] getMappedColumnNames() {
        InputColumn<?>[] inputColumns = this.getValue();
        ArrayList<String> result = new ArrayList<String>();
        for (InputColumn<?> inputColumn : inputColumns) {
            Column column;
            SourceColumnComboBox comboBox = this._mappedColumnComboBoxes.get(inputColumn);
            if (comboBox == null || (column = comboBox.getSelectedItem()) == null) continue;
            result.add(column.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<InputColumn<?>, SourceColumnComboBox> getMappedColumnComboBoxes() {
        return Collections.unmodifiableMap(this._mappedColumnComboBoxes);
    }

    @Override
    protected void selectAll() {
        this.batchUpdateWidget(new Runnable(){

            @Override
            public void run() {
                Collection comboBoxes = MultipleMappedColumnsPropertyWidget.this._mappedColumnComboBoxes.values();
                for (SourceColumnComboBox comboBox : comboBoxes) {
                    comboBox.setVisible(true);
                }
                MultipleMappedColumnsPropertyWidget.super.selectAll();
            }
        });
    }

    @Override
    protected void selectNone() {
        for (SourceColumnComboBox sourceColumnComboBox : this._mappedColumnComboBoxes.values()) {
            sourceColumnComboBox.setVisible(false);
        }
        super.selectNone();
    }

    @Override
    protected void onBatchFinished() {
        super.onBatchFinished();
        this._mappedColumnNamesPropertyWidget.fireValueChanged();
    }
}

