/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.EnumComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.MinimalPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleInputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;

public class MultipleMappedEnumsPropertyWidget<E extends Enum<?>>
extends MultipleInputColumnsPropertyWidget {
    private final WeakHashMap<InputColumn<?>, DCComboBox<E>> _mappedEnumComboBoxes = new WeakHashMap();
    private final ConfiguredPropertyDescriptor _mappedEnumsProperty;
    private final MinimalPropertyWidget<E[]> _mappedEnumsPropertyWidget;

    public MultipleMappedEnumsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor inputColumnsProperty, ConfiguredPropertyDescriptor mappedEnumsProperty) {
        super(beanJobBuilder, inputColumnsProperty);
        this._mappedEnumsProperty = mappedEnumsProperty;
        this._mappedEnumsPropertyWidget = this.createMappedEnumsPropertyWidget();
        InputColumn[] currentValue = (InputColumn[])this.getCurrentValue();
        Enum[] currentMappedEnums = (Enum[])beanJobBuilder.getConfiguredProperty(mappedEnumsProperty);
        if (currentValue != null && currentMappedEnums != null) {
            int minLength = Math.min(currentValue.length, currentMappedEnums.length);
            for (int i = 0; i < minLength; ++i) {
                InputColumn inputColumn = currentValue[i];
                Enum mappedEnum = currentMappedEnums[i];
                this.createComboBox(inputColumn, mappedEnum);
            }
        }
        if (currentValue != null) {
            this.setValue(currentValue);
        }
    }

    @Override
    protected boolean isAllInputColumnsSelectedIfNoValueExist() {
        return false;
    }

    private DCComboBox<E> createComboBox(InputColumn<?> inputColumn, E mappedEnum) {
        if (mappedEnum == null && inputColumn != null) {
            mappedEnum = this.getSuggestedValue(inputColumn);
        }
        Enum[] enumConstants = (Enum[])this._mappedEnumsProperty.getBaseType().getEnumConstants();
        DCComboBox<Enum> comboBox = new DCComboBox<Enum>(enumConstants);
        comboBox.setRenderer(new EnumComboBoxListRenderer());
        this._mappedEnumComboBoxes.put(inputColumn, comboBox);
        if (mappedEnum != null) {
            comboBox.setEditable(true);
            comboBox.setSelectedItem(mappedEnum);
            comboBox.setEditable(false);
        }
        comboBox.addListener(new DCComboBox.Listener<E>(){

            @Override
            public void onItemSelected(E item) {
                MultipleMappedEnumsPropertyWidget.this._mappedEnumsPropertyWidget.fireValueChanged();
            }
        });
        return comboBox;
    }

    protected E getSuggestedValue(InputColumn<?> inputColumn) {
        return null;
    }

    @Override
    protected JComponent decorateCheckBox(DCCheckBox<InputColumn<?>> checkBox) {
        InputColumn<?> inputColumn = checkBox.getValue();
        final DCComboBox<Object> comboBox = this._mappedEnumComboBoxes.containsKey(inputColumn) ? this._mappedEnumComboBoxes.get(inputColumn) : this.createComboBox(inputColumn, null);
        checkBox.addListener(new DCCheckBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item, boolean selected) {
                if (MultipleMappedEnumsPropertyWidget.this.isBatchUpdating()) {
                    return;
                }
                comboBox.setVisible(selected);
                MultipleMappedEnumsPropertyWidget.this._mappedEnumsPropertyWidget.fireValueChanged();
            }
        });
        boolean selected = checkBox.isSelected();
        comboBox.setVisible(selected);
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add(checkBox, "Center");
        panel.add(comboBox, "East");
        return panel;
    }

    public PropertyWidget<E[]> getMappedEnumsPropertyWidget() {
        return this._mappedEnumsPropertyWidget;
    }

    private MinimalPropertyWidget<E[]> createMappedEnumsPropertyWidget() {
        return new MinimalPropertyWidget<E[]>(this.getBeanJobBuilder(), this._mappedEnumsProperty){

            @Override
            public JComponent getWidget() {
                return null;
            }

            @Override
            public boolean isSet() {
                Object enumValues;
                for (Object enumValue : enumValues = this.getValue()) {
                    if (enumValue != null) continue;
                    return false;
                }
                InputColumn<?>[] inputColumns = MultipleMappedEnumsPropertyWidget.this.getValue();
                return ((E)enumValues).length == inputColumns.length;
            }

            @Override
            public E[] getValue() {
                return MultipleMappedEnumsPropertyWidget.this.getMappedEnums();
            }

            @Override
            protected void setValue(E[] value) {
                if (EqualsBuilder.equals(value, this.getValue())) {
                    return;
                }
                InputColumn<?>[] inputColumns = MultipleMappedEnumsPropertyWidget.this.getValue();
                for (int i = 0; i < inputColumns.length; ++i) {
                    InputColumn<?> inputColumn = inputColumns[i];
                    Object mappedEnum = value == null ? null : (i < value.length ? value[i] : null);
                    DCComboBox comboBox = (DCComboBox)MultipleMappedEnumsPropertyWidget.this._mappedEnumComboBoxes.get(inputColumn);
                    if (mappedEnum == null) continue;
                    comboBox.setEditable(true);
                    comboBox.setSelectedItem(mappedEnum);
                    comboBox.setEditable(false);
                }
            }
        };
    }

    private E[] getMappedEnums() {
        InputColumn<?>[] inputColumns = this.getValue();
        ArrayList<Enum> result = new ArrayList<Enum>();
        for (InputColumn<?> inputColumn : inputColumns) {
            DCComboBox<E> comboBox = this._mappedEnumComboBoxes.get(inputColumn);
            if (comboBox == null) {
                result.add(null);
                continue;
            }
            Enum value = (Enum)comboBox.getSelectedItem();
            result.add(value);
        }
        Enum[] array = (Enum[])Array.newInstance(this._mappedEnumsProperty.getBaseType(), result.size());
        return result.toArray(array);
    }

    @Override
    protected void selectAll() {
        for (DCComboBox<E> comboBox : this._mappedEnumComboBoxes.values()) {
            comboBox.setVisible(true);
        }
        super.selectAll();
    }

    @Override
    protected void selectNone() {
        for (DCComboBox<E> comboBox : this._mappedEnumComboBoxes.values()) {
            comboBox.setVisible(false);
        }
        super.selectNone();
    }
}

