/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.properties.MinimalPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleInputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.jdesktop.swingx.JXTextField;

public class MultipleMappedStringsPropertyWidget
extends MultipleInputColumnsPropertyWidget {
    private final WeakHashMap<InputColumn<?>, JXTextField> _mappedTextFields = new WeakHashMap();
    private final ConfiguredPropertyDescriptor _mappedStringsProperty;
    private final MinimalPropertyWidget<String[]> _mappedStringPropertyWidget;
    private volatile boolean _stringsUpdating;

    public MultipleMappedStringsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor inputColumnsProperty, ConfiguredPropertyDescriptor mappedStringsProperty) {
        super(beanJobBuilder, inputColumnsProperty);
        this._mappedStringsProperty = mappedStringsProperty;
        this._mappedStringPropertyWidget = this.createMappedStringsPropertyWidget();
        this._stringsUpdating = false;
        InputColumn[] currentValue = (InputColumn[])this.getCurrentValue();
        String[] currentMappedStringsValue = (String[])beanJobBuilder.getConfiguredProperty(mappedStringsProperty);
        if (currentValue != null && currentMappedStringsValue != null) {
            this._mappedStringPropertyWidget.setValue(currentMappedStringsValue);
            int minLength = Math.min(currentValue.length, currentMappedStringsValue.length);
            for (int i = 0; i < minLength; ++i) {
                InputColumn inputColumn = currentValue[i];
                String mappedString = currentMappedStringsValue[i];
                this.createTextField(inputColumn, mappedString);
            }
            this.setValue(currentValue);
        }
    }

    @Override
    protected boolean isAllInputColumnsSelectedIfNoValueExist() {
        return false;
    }

    private JXTextField createTextField(InputColumn<?> inputColumn, String mappedString) {
        JXTextField textField = WidgetFactory.createTextField();
        this._mappedTextFields.put(inputColumn, textField);
        if (mappedString == null) {
            mappedString = this.getDefaultMappedString(inputColumn);
        }
        if (mappedString != null) {
            textField.setText(mappedString);
        }
        textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                if (MultipleMappedStringsPropertyWidget.this.isBatchUpdating()) {
                    return;
                }
                MultipleMappedStringsPropertyWidget.this._stringsUpdating = true;
                MultipleMappedStringsPropertyWidget.this.fireValueChanged();
                MultipleMappedStringsPropertyWidget.this._mappedStringPropertyWidget.fireValueChanged();
                MultipleMappedStringsPropertyWidget.this._stringsUpdating = false;
            }
        });
        return textField;
    }

    protected String getDefaultMappedString(InputColumn<?> inputColumn) {
        return "";
    }

    @Override
    protected JComponent decorateCheckBox(DCCheckBox<InputColumn<?>> checkBox) {
        final JXTextField textField = this._mappedTextFields.containsKey(checkBox.getValue()) ? this._mappedTextFields.get(checkBox.getValue()) : this.createTextField(checkBox.getValue(), null);
        checkBox.addListenerToHead(new DCCheckBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item, boolean selected) {
                textField.setVisible(selected);
                MultipleMappedStringsPropertyWidget.this.updateUI();
            }
        });
        checkBox.addListener(new DCCheckBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item, boolean selected) {
                if (MultipleMappedStringsPropertyWidget.this.isBatchUpdating()) {
                    return;
                }
                MultipleMappedStringsPropertyWidget.this._mappedStringPropertyWidget.fireValueChanged();
            }
        });
        textField.setVisible(checkBox.isSelected());
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add(checkBox, "Center");
        panel.add((Component)textField, "East");
        return panel;
    }

    public PropertyWidget<String[]> getMappedStringsPropertyWidget() {
        return this._mappedStringPropertyWidget;
    }

    private MinimalPropertyWidget<String[]> createMappedStringsPropertyWidget() {
        return new MinimalPropertyWidget<String[]>(this.getBeanJobBuilder(), this._mappedStringsProperty){

            @Override
            public JComponent getWidget() {
                return null;
            }

            @Override
            public boolean isSet() {
                InputColumn<?>[] inputColumns;
                for (InputColumn<?> inputColumn : inputColumns = MultipleMappedStringsPropertyWidget.this.getValue()) {
                    JXTextField textField = (JXTextField)MultipleMappedStringsPropertyWidget.this._mappedTextFields.get(inputColumn);
                    if (!StringUtils.isNullOrEmpty((String)textField.getText())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String[] getValue() {
                return MultipleMappedStringsPropertyWidget.this.getMappedStrings();
            }

            @Override
            protected void setValue(String[] value) {
                if (MultipleMappedStringsPropertyWidget.this._stringsUpdating) {
                    return;
                }
                if (value == null) {
                    value = new String[]{};
                }
                if (EqualsBuilder.equals((Object)value, (Object)this.getValue())) {
                    return;
                }
                InputColumn<?>[] inputColumns = MultipleMappedStringsPropertyWidget.this.getValue();
                if (inputColumns.length != value.length) {
                    return;
                }
                for (int i = 0; i < inputColumns.length; ++i) {
                    JXTextField textField;
                    String previousText;
                    InputColumn<?> inputColumn = inputColumns[i];
                    String mappedString = value == null ? MultipleMappedStringsPropertyWidget.this.getDefaultMappedString(inputColumn) : (i < value.length ? value[i] : MultipleMappedStringsPropertyWidget.this.getDefaultMappedString(inputColumn));
                    if (mappedString.equals(previousText = (textField = (JXTextField)MultipleMappedStringsPropertyWidget.this._mappedTextFields.get(inputColumn)).getText())) continue;
                    textField.setText(mappedString);
                }
            }
        };
    }

    @Override
    public InputColumn<?>[] getValue() {
        InputColumn<?>[] checkedInputColumns = super.getValue();
        ArrayList result = new ArrayList();
        for (InputColumn<?> inputColumn : checkedInputColumns) {
            JXTextField textField = this._mappedTextFields.get(inputColumn);
            if (textField == null || !textField.isVisible() || StringUtils.isNullOrEmpty((String)textField.getText())) continue;
            result.add(inputColumn);
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    private String[] getMappedStrings() {
        InputColumn<?>[] inputColumns = this.getValue();
        ArrayList<String> result = new ArrayList<String>();
        for (InputColumn<?> inputColumn : inputColumns) {
            String value;
            JXTextField textField = this._mappedTextFields.get(inputColumn);
            if (textField == null || StringUtils.isNullOrEmpty((String)(value = textField.getText()))) continue;
            result.add(value);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void selectAll() {
        for (JXTextField textField : this._mappedTextFields.values()) {
            textField.setVisible(true);
        }
        super.selectAll();
    }

    @Override
    protected void selectNone() {
        for (JXTextField textField : this._mappedTextFields.values()) {
            textField.setVisible(false);
        }
        super.selectNone();
    }
}

