/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.StringPatternChangeListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractMultipleCheckboxesPropertyWidget;
import org.eobjects.datacleaner.windows.ReferenceDataDialog;

public class MultipleStringPatternPropertyWidget
extends AbstractMultipleCheckboxesPropertyWidget<StringPattern>
implements StringPatternChangeListener {
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private final Provider<ReferenceDataDialog> _referenceDataDialogProvider;

    @Inject
    public MultipleStringPatternPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, MutableReferenceDataCatalog referenceDataCatalog, Provider<ReferenceDataDialog> referenceDataDialogProvider) {
        super(beanJobBuilder, propertyDescriptor, StringPattern.class);
        this._referenceDataCatalog = referenceDataCatalog;
        this._referenceDataDialogProvider = referenceDataDialogProvider;
    }

    @Override
    public void onPanelAdd() {
        super.onPanelAdd();
        this._referenceDataCatalog.addStringPatternListener(this);
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._referenceDataCatalog.removeStringPatternListener(this);
    }

    @Override
    protected DCPanel createButtonPanel() {
        DCPanel buttonPanel = super.createButtonPanel();
        JButton dialogButton = WidgetFactory.createSmallButton("images/menu/options.png");
        dialogButton.setToolTipText("Configure string patterns");
        dialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog dialog = (ReferenceDataDialog)MultipleStringPatternPropertyWidget.this._referenceDataDialogProvider.get();
                dialog.selectStringPatternsTab();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(dialogButton);
        return buttonPanel;
    }

    protected StringPattern[] getAvailableValues() {
        String[] names = this._referenceDataCatalog.getStringPatternNames();
        StringPattern[] result = new StringPattern[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this._referenceDataCatalog.getStringPattern(names[i]);
        }
        return result;
    }

    @Override
    protected String getName(StringPattern item) {
        return item.getName();
    }

    @Override
    public void onAdd(StringPattern stringPattern) {
        this.addCheckBox(stringPattern, false);
    }

    @Override
    public void onRemove(StringPattern stringPattern) {
        this.removeCheckBox(stringPattern);
    }

    @Override
    protected String getNotAvailableText() {
        return "- no string patterns available - ";
    }
}

