/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class MultipleStringPropertyWidget
extends AbstractPropertyWidget<String[]> {
    private final DCPanel _textFieldPanel;
    private final Map<JComponent, JXTextField> _textFieldDecorations = new IdentityHashMap<JComponent, JXTextField>();

    @Inject
    public MultipleStringPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textFieldPanel = new DCPanel();
        this._textFieldPanel.setLayout((LayoutManager)new VerticalLayout(2));
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleStringPropertyWidget.this.addTextField("", true);
                MultipleStringPropertyWidget.this.fireValueChanged();
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int componentCount = MultipleStringPropertyWidget.this._textFieldPanel.getComponentCount();
                if (componentCount > 0) {
                    MultipleStringPropertyWidget.this.removeTextField();
                    MultipleStringPropertyWidget.this._textFieldPanel.updateUI();
                    MultipleStringPropertyWidget.this.fireValueChanged();
                }
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._textFieldPanel, "Center");
        outerPanel.add((Component)buttonPanel, "East");
        this.add(outerPanel);
    }

    @Override
    public void initialize(String[] value) {
        this.updateComponents(value);
    }

    public void updateComponents(String[] values) {
        String[] previousValues;
        if (values == null) {
            values = new String[2];
        }
        if (!EqualsBuilder.equals((Object)values, (Object)(previousValues = this.getValue()))) {
            for (int i = 0; i < Math.min(previousValues.length, values.length); ++i) {
                if (EqualsBuilder.equals((Object)previousValues[i], (Object)values[i])) continue;
                Component decoration = this._textFieldPanel.getComponent(i);
                JXTextField component = this._textFieldDecorations.get(decoration);
                component.setText(values[i]);
            }
            while (this._textFieldPanel.getComponentCount() < values.length) {
                String nextValue = values[this._textFieldPanel.getComponentCount()];
                this.addTextField(nextValue, false);
            }
            while (this._textFieldPanel.getComponentCount() > values.length) {
                this.removeTextField();
            }
            this._textFieldPanel.updateUI();
        }
    }

    private void removeTextField() {
        int componentCount = this._textFieldPanel.getComponentCount();
        if (componentCount == 0) {
            return;
        }
        int index = componentCount - 1;
        Component decoration = this._textFieldPanel.getComponent(index);
        this._textFieldDecorations.remove(decoration);
        this._textFieldPanel.remove(index);
    }

    private void addTextField(String value, boolean updateUI) {
        JXTextField textField = WidgetFactory.createTextField();
        if (value != null) {
            textField.setText(value);
        }
        textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                MultipleStringPropertyWidget.this.fireValueChanged();
            }
        });
        int index = this._textFieldPanel.getComponentCount();
        JComponent decoration = this.decorateTextField(textField, index);
        this._textFieldDecorations.put(decoration, textField);
        this._textFieldPanel.add(decoration);
        if (updateUI) {
            this._textFieldPanel.updateUI();
        }
    }

    protected JComponent decorateTextField(JXTextField textField, int index) {
        return textField;
    }

    @Override
    public String[] getValue() {
        Component[] components = this._textFieldPanel.getComponents();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < components.length; ++i) {
            Component decoration = components[i];
            JXTextField textField = this._textFieldDecorations.get(decoration);
            String text = textField.getText();
            if (!this.isEmptyStringValid() && text.length() == 0) continue;
            result.add(text);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean isSet() {
        String[] value = this.getValue();
        if (value.length == 0) {
            return false;
        }
        if (!this.isEmptyStringValid()) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i].length() != 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isEmptyStringValid() {
        return true;
    }

    @Override
    protected void setValue(String[] value) {
        this.updateComponents(value);
    }
}

