/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.SynonymCatalogChangeListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractMultipleCheckboxesPropertyWidget;
import org.eobjects.datacleaner.windows.ReferenceDataDialog;

public class MultipleSynonymCatalogsPropertyWidget
extends AbstractMultipleCheckboxesPropertyWidget<SynonymCatalog>
implements SynonymCatalogChangeListener {
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private final Provider<ReferenceDataDialog> _referenceDataDialogProvider;

    @Inject
    public MultipleSynonymCatalogsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, MutableReferenceDataCatalog referenceDataCatalog, Provider<ReferenceDataDialog> referenceDataDialogProvider) {
        super(beanJobBuilder, propertyDescriptor, SynonymCatalog.class);
        this._referenceDataCatalog = referenceDataCatalog;
        this._referenceDataDialogProvider = referenceDataDialogProvider;
    }

    @Override
    public void onPanelAdd() {
        super.onPanelAdd();
        this._referenceDataCatalog.addSynonymCatalogListener(this);
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._referenceDataCatalog.removeSynonymCatalogListener(this);
    }

    @Override
    protected DCPanel createButtonPanel() {
        DCPanel buttonPanel = super.createButtonPanel();
        JButton dialogButton = WidgetFactory.createSmallButton("images/menu/options.png");
        dialogButton.setToolTipText("Configure synonym catalogs");
        dialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog dialog = (ReferenceDataDialog)MultipleSynonymCatalogsPropertyWidget.this._referenceDataDialogProvider.get();
                dialog.selectSynonymsTab();
                dialog.setVisible(true);
            }
        });
        buttonPanel.add(dialogButton);
        return buttonPanel;
    }

    protected SynonymCatalog[] getAvailableValues() {
        String[] names = this._referenceDataCatalog.getSynonymCatalogNames();
        SynonymCatalog[] result = new SynonymCatalog[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this._referenceDataCatalog.getSynonymCatalog(names[i]);
        }
        return result;
    }

    @Override
    protected String getName(SynonymCatalog item) {
        return item.getName();
    }

    @Override
    public void onAdd(SynonymCatalog synonymCatalog) {
        this.addCheckBox(synonymCatalog, false);
    }

    @Override
    public void onRemove(SynonymCatalog synonymCatalog) {
        this.removeCheckBox(synonymCatalog);
    }

    @Override
    protected String getNotAvailableText() {
        return "- no synonym catalogs available - ";
    }
}

