/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.PropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.widgets.properties.DummyPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleCharPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleDictionariesPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleEnumPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleInputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleNumberPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleStringPatternPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleStringPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleSynonymCatalogsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleBooleanPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleCharacterPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleClassPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleDatastorePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleDatePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleDictionaryPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleEnumPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleFilePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleInputColumnComboBoxPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleInputColumnRadioButtonPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleNumberPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SinglePatternPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleStringPatternPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleStringPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleSynonymCatalogPropertyWidget;

public final class PropertyWidgetFactory {
    public static final TypeLiteral<AbstractBeanJobBuilder<?, ?, ?>> TYPELITERAL_BEAN_JOB_BUILDER = new TypeLiteral<AbstractBeanJobBuilder<?, ?, ?>>(){};
    private final AbstractBeanJobBuilder<?, ?, ?> _beanJobBuilder;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidget<?>> _widgets = new HashMap();
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected PropertyWidgetFactory(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, InjectorBuilder injectorBuilder) {
        this._beanJobBuilder = beanJobBuilder;
        this._injectorBuilder = injectorBuilder;
    }

    public Collection<PropertyWidget<?>> getWidgets() {
        return this._widgets.values();
    }

    public PropertyWidget<?> getWidget(ConfiguredPropertyDescriptor propertyDescriptor) {
        return this._widgets.get(propertyDescriptor);
    }

    public AbstractBeanJobBuilder<?, ?, ?> getBeanJobBuilder() {
        return this._beanJobBuilder;
    }

    public Injector getInjectorForPropertyWidgets(ConfiguredPropertyDescriptor propertyDescriptor) {
        return this._injectorBuilder.inherit(TYPELITERAL_BEAN_JOB_BUILDER).with(ConfiguredPropertyDescriptor.class, (Object)propertyDescriptor).with(PropertyDescriptor.class, (Object)propertyDescriptor).createInjector();
    }

    public PropertyWidget<?> create(String propertyName) {
        BeanDescriptor descriptor = this._beanJobBuilder.getDescriptor();
        ConfiguredPropertyDescriptor propertyDescriptor = descriptor.getConfiguredProperty(propertyName);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("No such property: " + propertyName);
        }
        return this.create(propertyDescriptor);
    }

    public PropertyWidget<?> create(ConfiguredPropertyDescriptor propertyDescriptor) {
        Class type = propertyDescriptor.getBaseType();
        Class widgetClass = propertyDescriptor.isArray() ? (propertyDescriptor.isInputColumn() ? MultipleInputColumnsPropertyWidget.class : (ReflectionUtils.isString((Type)type) ? MultipleStringPropertyWidget.class : (type == Dictionary.class ? MultipleDictionariesPropertyWidget.class : (type == SynonymCatalog.class ? MultipleSynonymCatalogsPropertyWidget.class : (type == StringPattern.class ? MultipleStringPatternPropertyWidget.class : (type.isEnum() ? MultipleEnumPropertyWidget.class : (type == Character.TYPE ? MultipleCharPropertyWidget.class : (ReflectionUtils.isNumber((Type)type) ? MultipleNumberPropertyWidget.class : DummyPropertyWidget.class)))))))) : (propertyDescriptor.isInputColumn() ? (this._beanJobBuilder.getDescriptor().getConfiguredPropertiesForInput().size() == 1 ? SingleInputColumnRadioButtonPropertyWidget.class : SingleInputColumnComboBoxPropertyWidget.class) : (ReflectionUtils.isCharacter((Type)type) ? SingleCharacterPropertyWidget.class : (ReflectionUtils.isString((Type)type) ? SingleStringPropertyWidget.class : (ReflectionUtils.isBoolean((Type)type) ? SingleBooleanPropertyWidget.class : (ReflectionUtils.isNumber((Type)type) ? SingleNumberPropertyWidget.class : (ReflectionUtils.isDate((Type)type) ? SingleDatePropertyWidget.class : (type == Dictionary.class ? SingleDictionaryPropertyWidget.class : (type == SynonymCatalog.class ? SingleSynonymCatalogPropertyWidget.class : (type == StringPattern.class ? SingleStringPatternPropertyWidget.class : (type.isEnum() ? SingleEnumPropertyWidget.class : (type == File.class ? SingleFilePropertyWidget.class : (type == Pattern.class ? SinglePatternPropertyWidget.class : (ReflectionUtils.is((Type)type, Datastore.class) ? SingleDatastorePropertyWidget.class : (type == Class.class ? SingleClassPropertyWidget.class : DummyPropertyWidget.class))))))))))))));
        Injector injector = this.getInjectorForPropertyWidgets(propertyDescriptor);
        PropertyWidget result = (PropertyWidget)injector.getInstance(widgetClass);
        this.registerWidget(propertyDescriptor, result);
        return result;
    }

    public void registerWidget(ConfiguredPropertyDescriptor propertyDescriptor, PropertyWidget<?> widget) {
        if (widget == null) {
            this._widgets.remove(propertyDescriptor);
        } else {
            this._widgets.put(propertyDescriptor, widget);
            PropertyWidget<?> objectWidget = widget;
            Object value = this._beanJobBuilder.getConfiguredProperty(objectWidget.getPropertyDescriptor());
            objectWidget.initialize(value);
        }
    }

    public void onConfigurationChanged() {
        Collection<PropertyWidget<?>> widgets = this.getWidgets();
        Iterator<PropertyWidget<?>> i$ = widgets.iterator();
        while (i$.hasNext()) {
            PropertyWidget<?> widget;
            PropertyWidget<?> objectWidget = widget = i$.next();
            ConfiguredPropertyDescriptor propertyDescriptor = objectWidget.getPropertyDescriptor();
            Object value = this._beanJobBuilder.getConfiguredProperty(propertyDescriptor);
            objectWidget.onValueTouched(value);
        }
    }
}

