/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.jdesktop.swingx.JXLabel;

public abstract class PropertyWidgetPanel
extends DCPanel {
    private static final int FIELD_LABEL_WIDTH = 200;
    private static final long serialVersionUID = 1L;
    private static final Insets insets = new Insets(4, 4, 4, 4);
    private int _rowCounter;

    public PropertyWidgetPanel() {
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{200};
        this.setLayout(layout);
        this._rowCounter = 0;
    }

    public boolean isEmpty() {
        return this.getComponentCount() == 0;
    }

    public void addProperties(Collection<ConfiguredPropertyDescriptor> properties) {
        for (ConfiguredPropertyDescriptor propertyDescriptor : properties) {
            JComponent component;
            PropertyWidget<?> propertyWidget = this.getPropertyWidget(propertyDescriptor);
            if (propertyWidget == null || (component = propertyWidget.getWidget()) == null) continue;
            String propertyName = propertyDescriptor.getName();
            if (!propertyName.endsWith(":")) {
                propertyName = propertyName + ":";
            }
            DCLabel propertyLabel = DCLabel.dark(propertyName);
            propertyLabel.setFont(WidgetUtils.FONT_SMALL);
            this.add((Component)propertyLabel, new GridBagConstraints(0, this._rowCounter, 1, 1, 0.0, 0.0, 18, 1, insets, 0, 0));
            String description = propertyDescriptor.getDescription();
            if (!StringUtils.isNullOrEmpty((String)description)) {
                propertyLabel.setToolTipText(description);
                JXLabel descriptionLabel = new JXLabel(description);
                descriptionLabel.setLineWrap(true);
                descriptionLabel.setFont(WidgetUtils.FONT_SMALL);
                descriptionLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
                descriptionLabel.setVerticalAlignment(1);
                descriptionLabel.setPreferredSize(new Dimension(196, 0));
                this.add((Component)descriptionLabel, new GridBagConstraints(0, this._rowCounter + 1, 1, 1, 0.0, 1.0, 18, 1, insets, 0, 0));
            }
            this.add((Component)component, new GridBagConstraints(1, this._rowCounter, 1, 2, 1.0, 1.0, 12, 1, insets, 0, 0));
            this._rowCounter += 2;
        }
    }

    protected abstract PropertyWidget<?> getPropertyWidget(ConfiguredPropertyDescriptor var1);
}

