/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import javax.swing.DefaultComboBoxModel;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SchemaStructureComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.schema.MutableSchema;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.MutableRef;

public class SchemaNamePropertyWidget
extends AbstractPropertyWidget<String> {
    private final DCComboBox<Schema> _comboBox = new DCComboBox();
    private final MutableRef<Datastore> _datastoreRef;

    public SchemaNamePropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this._comboBox.setRenderer(new SchemaStructureComboBoxListRenderer(false));
        this._comboBox.setEditable(false);
        this.addComboListener(new DCComboBox.Listener<Schema>(){

            @Override
            public void onItemSelected(Schema item) {
                SchemaNamePropertyWidget.this.fireValueChanged();
            }
        });
        this.add(this._comboBox);
        this._datastoreRef = new MutableRef();
        this.setValue((String)this.getCurrentValue());
    }

    public void addComboListener(DCComboBox.Listener<Schema> listener) {
        this._comboBox.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatastore(Datastore datastore) {
        String previousValue = this.getValue();
        this._datastoreRef.set((Object)datastore);
        if (datastore == null) {
            this._comboBox.setModel(new DefaultComboBoxModel<Object>(new Object[1]));
        } else {
            DatastoreConnection con = datastore.openConnection();
            try {
                Object[] schemas = con.getSchemaNavigator().getSchemas();
                schemas = (Schema[])CollectionUtils.array((Object[])new Schema[1], (Object[])schemas);
                this._comboBox.setModel(new DefaultComboBoxModel<Object>(schemas));
                Schema newValue = null;
                if (previousValue != null) {
                    newValue = con.getSchemaNavigator().getSchemaByName(previousValue);
                }
                if (newValue == null) {
                    newValue = con.getSchemaNavigator().getDefaultSchema();
                }
                this._comboBox.setSelectedItem(newValue);
            }
            finally {
                con.close();
            }
        }
    }

    @Override
    public String getValue() {
        Schema schema = this.getSchema();
        if (schema == null) {
            return null;
        }
        return schema.getName();
    }

    public Schema getSchema() {
        Schema schema = this._comboBox.getSelectedItem();
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setValue(String value) {
        MutableSchema schema;
        Datastore datastore = (Datastore)this._datastoreRef.get();
        if (value == null && datastore != null) {
            DatastoreConnection con = datastore.openConnection();
            try {
                value = con.getSchemaNavigator().getDefaultSchema().getName();
            }
            finally {
                con.close();
            }
        }
        if (this.getValue() == value) {
            return;
        }
        if (value == null) {
            schema = null;
        } else if (datastore == null) {
            schema = new MutableSchema(value);
        } else {
            DatastoreConnection con = datastore.openConnection();
            try {
                schema = con.getSchemaNavigator().getSchemaByName(value);
            }
            finally {
                con.close();
            }
        }
        this._comboBox.setEditable(true);
        this._comboBox.setSelectedItem(schema);
        this._comboBox.setEditable(false);
    }
}

