/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JCheckBox;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;

public class SingleBooleanPropertyWidget
extends AbstractPropertyWidget<Boolean> {
    private final JCheckBox _checkBox;
    private final DCComboBox<String> _comboBox;

    @Inject
    public SingleBooleanPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        boolean useCheckBox;
        Boolean currentValue = (Boolean)this.getCurrentValue();
        boolean bl = useCheckBox = propertyDescriptor.isRequired() || propertyDescriptor.getBaseType().isPrimitive();
        if (useCheckBox) {
            this._checkBox = new JCheckBox();
            this._comboBox = null;
            this._checkBox.setOpaque(false);
            if (currentValue != null) {
                this._checkBox.setSelected(currentValue);
            }
            this._checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SingleBooleanPropertyWidget.this.fireValueChanged();
                }
            });
            this.add(this._checkBox);
        } else {
            this._checkBox = null;
            this._comboBox = new DCComboBox<String>(new String[]{"true", "false", "<null>"});
            if (currentValue == null) {
                this._comboBox.setSelectedItem("<null>");
            } else {
                this._comboBox.setSelectedItem(currentValue.toString());
            }
            this._comboBox.addListener(new DCComboBox.Listener<String>(){

                @Override
                public void onItemSelected(String item) {
                    SingleBooleanPropertyWidget.this.fireValueChanged();
                }
            });
            this.add(this._comboBox);
        }
    }

    @Override
    public boolean isSet() {
        String selectedItem;
        return this._comboBox == null || !"<null>".equals(selectedItem = this._comboBox.getSelectedItem());
    }

    @Override
    public Boolean getValue() {
        if (this._checkBox == null) {
            String selectedItem = this._comboBox.getSelectedItem();
            if ("<null>".equals(selectedItem)) {
                return null;
            }
            return Boolean.parseBoolean(selectedItem);
        }
        return this._checkBox.isSelected();
    }

    @Override
    protected void setValue(Boolean value) {
        if (this._checkBox == null) {
            if (value == null) {
                this._comboBox.setSelectedItem("<null>");
            } else if (value.booleanValue()) {
                this._comboBox.setSelectedItem("true");
            } else {
                this._comboBox.setSelectedItem("false");
            }
        } else if (value == null) {
            this._checkBox.setSelected(false);
        } else {
            this._checkBox.setSelected(value);
        }
    }
}

