/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import javax.inject.Inject;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.widgets.CharTextField;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;

public class SingleCharacterPropertyWidget
extends AbstractPropertyWidget<Character> {
    private final CharTextField _textField;
    private final DCDocumentListener _listener = new DCDocumentListener(){

        @Override
        protected void onChange(DocumentEvent e) {
            SingleCharacterPropertyWidget.this.fireValueChanged();
        }
    };

    @Inject
    public SingleCharacterPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textField = new CharTextField();
        Character currentValue = (Character)this.getCurrentValue();
        this.setValue(currentValue);
        this._textField.addDocumentListener(this._listener);
        this.add(this._textField);
    }

    @Override
    public boolean isSet() {
        Character value = this._textField.getValue();
        return value != null;
    }

    @Override
    public Character getValue() {
        Character value = this._textField.getValue();
        if (value == null) {
            if (this.getPropertyDescriptor().getBaseType().isPrimitive()) {
                return Character.valueOf('\u0000');
            }
            return null;
        }
        return value;
    }

    @Override
    protected void setValue(Character value) {
        this._textField.removeDocumentListener(this._listener);
        this._textField.setValue(value);
        this._textField.addDocumentListener(this._listener);
    }
}

