/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.JList;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCListCellRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;

public class SingleClassPropertyWidget
extends AbstractPropertyWidget<Class<?>> {
    private final DCComboBox<Class<?>> _comboBox;

    @Inject
    public SingleClassPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._comboBox = SingleClassPropertyWidget.createClassComboBox(propertyDescriptor.isRequired());
        Class currentValue = (Class)this.getCurrentValue();
        if (currentValue != null) {
            this._comboBox.setSelectedItem(currentValue);
        }
        this._comboBox.addListener(new DCComboBox.Listener<Class<?>>(){

            @Override
            public void onItemSelected(Class<?> item) {
                SingleClassPropertyWidget.this.fireValueChanged(item);
            }
        });
        this.add(this._comboBox);
    }

    public static DCComboBox<Class<?>> createClassComboBox(boolean required) {
        ArrayList<Class<Object>> items = new ArrayList<Class<Object>>();
        if (!required) {
            items.add(null);
        }
        items.add(String.class);
        items.add(Number.class);
        items.add(Date.class);
        items.add(Boolean.class);
        items.add(List.class);
        items.add(Map.class);
        items.add(Object.class);
        DCComboBox comboBox = new DCComboBox(items);
        comboBox.setRenderer(new DCListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Class) {
                    value = ((Class)value).getSimpleName();
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        return comboBox;
    }

    @Override
    public Class<?> getValue() {
        return this._comboBox.getSelectedItem();
    }

    @Override
    protected void setValue(Class<?> value) {
        this._comboBox.setSelectedItem(value);
    }
}

