/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.user.DatastoreChangeListener;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SchemaStructureComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDatastorePropertyWidget
extends AbstractPropertyWidget<Datastore>
implements DatastoreChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(SingleDatastorePropertyWidget.class);
    private final DatastoreCatalog _datastoreCatalog;
    private final DCComboBox<Datastore> _comboBox;
    private final Class<?> _datastoreClass;
    private volatile DatastoreConnection _connection;

    @Inject
    public SingleDatastorePropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor, DatastoreCatalog datastoreCatalog) {
        super(beanJobBuilder, propertyDescriptor);
        this._datastoreCatalog = datastoreCatalog;
        this._datastoreClass = propertyDescriptor.getBaseType();
        String[] datastoreNames = this._datastoreCatalog.getDatastoreNames();
        ArrayList<Datastore> list = new ArrayList<Datastore>();
        if (!propertyDescriptor.isRequired()) {
            list.add(null);
        }
        for (int i = 0; i < datastoreNames.length; ++i) {
            Datastore datastore = this._datastoreCatalog.getDatastore(datastoreNames[i]);
            if (!ReflectionUtils.is(datastore.getClass(), this._datastoreClass)) continue;
            list.add(datastore);
        }
        this._comboBox = new DCComboBox(list);
        this._comboBox.setRenderer(new SchemaStructureComboBoxListRenderer());
        this.addComboListener(new DCComboBox.Listener<Datastore>(){

            @Override
            public void onItemSelected(Datastore item) {
                SingleDatastorePropertyWidget.this.openConnection(item);
                SingleDatastorePropertyWidget.this.fireValueChanged();
            }
        });
        Datastore currentValue = (Datastore)beanJobBuilder.getConfiguredProperty(propertyDescriptor);
        this.setValue(currentValue);
        this.add(this._comboBox);
    }

    public void addComboListener(DCComboBox.Listener<Datastore> listener) {
        this._comboBox.addListener(listener);
    }

    @Override
    public void onPanelAdd() {
        super.onPanelAdd();
        if (this._datastoreCatalog instanceof MutableDatastoreCatalog) {
            ((MutableDatastoreCatalog)this._datastoreCatalog).addListener(this);
        }
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        if (this._datastoreCatalog instanceof MutableDatastoreCatalog) {
            ((MutableDatastoreCatalog)this._datastoreCatalog).removeListener(this);
        }
        this.openConnection(null);
    }

    @Override
    public Datastore getValue() {
        Datastore selectedItem;
        Datastore datastore = selectedItem = this._comboBox.getSelectedItem();
        this.openConnection(datastore);
        return datastore;
    }

    @Override
    protected void setValue(Datastore value) {
        if (value == null) {
            this._comboBox.setSelectedItem(null);
            return;
        }
        if (this.getValue() == value) {
            return;
        }
        this.openConnection(value);
        this._comboBox.setEditable(true);
        this._comboBox.setSelectedItem(value);
        this._comboBox.setEditable(false);
    }

    private void openConnection(Datastore datastore) {
        if (this._connection != null && this._connection.getDatastore() == datastore) {
            return;
        }
        if (this._connection != null) {
            this._connection.close();
            this._connection = null;
        }
        if (datastore != null) {
            try {
                this._connection = datastore.openConnection();
            }
            catch (Exception e) {
                logger.warn("Could not open connection to datastore: {}", (Object)datastore);
            }
        }
    }

    @Override
    public void onAdd(Datastore datastore) {
        if (ReflectionUtils.is(datastore.getClass(), this._datastoreClass)) {
            this._comboBox.setEditable(true);
            this._comboBox.addItem(datastore);
            this._comboBox.setEditable(false);
        }
    }

    @Override
    public void onRemove(Datastore datastore) {
        this._comboBox.setEditable(true);
        this._comboBox.removeItem(datastore);
        this._comboBox.setEditable(false);
    }
}

