/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.inject.Inject;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.convert.NowDate;
import org.eobjects.analyzer.util.convert.TodayDate;
import org.eobjects.analyzer.util.convert.YesterdayDate;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.JXDatePicker;

public class SingleDatePropertyWidget
extends AbstractPropertyWidget<Date> {
    private final JXDatePicker _datePicker = new JXDatePicker();
    private final JRadioButton _dateCustomRadio;
    private final JRadioButton _dateNowRadio;
    private final JRadioButton _dateTodayRadio;
    private final JRadioButton _dateYesterdayRadio;

    @Inject
    public SingleDatePropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._datePicker.setFormats(new String[]{"yyyy-MM-dd"});
        this._dateCustomRadio = new JRadioButton("Select: ");
        this._dateNowRadio = new JRadioButton("Now");
        this._dateTodayRadio = new JRadioButton("Today");
        this._dateYesterdayRadio = new JRadioButton("Yesterday");
        this._datePicker.addActionListener(this.fireValueChangedActionListener());
        this._dateCustomRadio.addActionListener(this.fireValueChangedActionListener());
        this._dateNowRadio.addActionListener(this.fireValueChangedActionListener());
        this._dateTodayRadio.addActionListener(this.fireValueChangedActionListener());
        this._dateYesterdayRadio.addActionListener(this.fireValueChangedActionListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._dateCustomRadio);
        buttonGroup.add(this._dateNowRadio);
        buttonGroup.add(this._dateTodayRadio);
        buttonGroup.add(this._dateYesterdayRadio);
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)DCPanel.flow(Alignment.LEFT, 4, 0, new Component[]{this._dateCustomRadio, this._datePicker}), "Center");
        panel.add((Component)DCPanel.flow(Alignment.LEFT, 4, 0, this._dateNowRadio, this._dateTodayRadio, this._dateYesterdayRadio), "South");
        this.add(panel);
        Date currentValue = (Date)this.getCurrentValue();
        this.setValue(currentValue);
    }

    @Override
    public Date getValue() {
        if (this._dateNowRadio.isSelected()) {
            return new NowDate();
        }
        if (this._dateTodayRadio.isSelected()) {
            return new TodayDate();
        }
        if (this._dateYesterdayRadio.isSelected()) {
            return new YesterdayDate();
        }
        return this._datePicker.getDate();
    }

    @Override
    protected void setValue(Date value) {
        if (value instanceof NowDate) {
            this._dateNowRadio.setSelected(true);
        } else if (value instanceof TodayDate) {
            this._dateTodayRadio.setSelected(true);
        } else if (value instanceof YesterdayDate) {
            this._dateYesterdayRadio.setSelected(true);
        } else {
            this._dateCustomRadio.setSelected(true);
            if (value != null) {
                this._datePicker.setDate(value);
            }
        }
    }
}

