/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import javax.inject.Inject;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.EnumComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.util.CollectionUtils;

public final class SingleEnumPropertyWidget
extends AbstractPropertyWidget<Enum<?>> {
    private final DCComboBox<Enum<?>> _comboBox;

    @Inject
    public SingleEnumPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        Object[] enumConstants = (Enum[])propertyDescriptor.getType().getEnumConstants();
        if (!propertyDescriptor.isRequired()) {
            enumConstants = (Enum[])CollectionUtils.array((Object[])new Enum[]{null}, (Object[])enumConstants);
        }
        this._comboBox = new DCComboBox<Enum>(enumConstants);
        this._comboBox.setRenderer(new EnumComboBoxListRenderer());
        Enum currentValue = (Enum)this.getCurrentValue();
        this._comboBox.setSelectedItem(currentValue);
        this.addComboListener(new DCComboBox.Listener<Enum<?>>(){

            @Override
            public void onItemSelected(Enum<?> item) {
                SingleEnumPropertyWidget.this.fireValueChanged();
            }
        });
        this.add(this._comboBox);
    }

    public void addComboListener(DCComboBox.Listener<Enum<?>> listener) {
        this._comboBox.addListener(listener);
    }

    @Override
    public Enum<?> getValue() {
        return this._comboBox.getSelectedItem();
    }

    @Override
    protected void setValue(Enum<?> value) {
        this._comboBox.setSelectedItem(value);
    }
}

