/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import org.eobjects.analyzer.beans.api.FileProperty;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.ExtensionFilter;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.eobjects.datacleaner.widgets.FilenameTextField;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;

public final class SingleFilePropertyWidget
extends AbstractPropertyWidget<File> {
    private final FilenameTextField _filenameField;
    private final UserPreferences _userPreferences;

    @Inject
    public SingleFilePropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, UserPreferences userPreferences) {
        super(beanJobBuilder, propertyDescriptor);
        this._userPreferences = userPreferences;
        boolean openFileDialog = true;
        String[] extensions = null;
        FileProperty fileProperty = (FileProperty)propertyDescriptor.getAnnotation(FileProperty.class);
        if (fileProperty != null) {
            openFileDialog = fileProperty.accessMode() == FileProperty.FileAccessMode.OPEN;
            extensions = fileProperty.extension();
        }
        this._filenameField = new FilenameTextField(this._userPreferences.getConfiguredFileDirectory(), openFileDialog);
        if (extensions != null && extensions.length > 0) {
            ArrayList<ExtensionFilter> filters = new ArrayList<ExtensionFilter>(extensions.length);
            for (String extension : extensions) {
                ExtensionFilter filter = new ExtensionFilter(extension.toUpperCase() + " file", "." + extension);
                filters.add(filter);
                this._filenameField.addChoosableFileFilter(filter);
            }
            if (filters.size() == 1) {
                this._filenameField.setSelectedFileFilter((FileFilter)filters.get(0));
            } else {
                FileFilter filter = FileFilters.combined("All suggested file formats", filters.toArray(new FileFilter[filters.size()]));
                this._filenameField.setSelectedFileFilter(filter);
            }
        } else {
            this._filenameField.setSelectedFileFilter(FileFilters.ALL);
        }
        File currentValue = (File)this.getCurrentValue();
        if (currentValue != null) {
            this._filenameField.setFile(currentValue);
        }
        this._filenameField.getTextField().getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                SingleFilePropertyWidget.this.fireValueChanged();
            }
        });
        this._filenameField.addFileSelectionListener(new FileSelectionListener(){

            @Override
            public void onSelected(FilenameTextField filenameTextField, File file) {
                File dir = file.getParentFile();
                SingleFilePropertyWidget.this._userPreferences.setConfiguredFileDirectory(dir);
                SingleFilePropertyWidget.this.fireValueChanged();
            }
        });
        this.add(this._filenameField);
    }

    @Override
    public boolean isSet() {
        return this._filenameField.getFile() != null;
    }

    public FilenameTextField getFilenameField() {
        return this._filenameField;
    }

    @Override
    public File getValue() {
        String text = this._filenameField.getFilename();
        if (StringUtils.isNullOrEmpty((String)text)) {
            return null;
        }
        File file = new File(text);
        return file;
    }

    @Override
    protected void setValue(File value) {
        if (value == null) {
            this._filenameField.setFilename("");
            return;
        }
        File existingFile = this._filenameField.getFile();
        if (existingFile != null && existingFile.getAbsoluteFile().equals(value.getAbsoluteFile())) {
            return;
        }
        this._filenameField.setFilename(value.getAbsolutePath());
    }
}

