/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.ComboBoxModel;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SchemaStructureComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class SingleInputColumnComboBoxPropertyWidget
extends AbstractPropertyWidget<InputColumn<?>>
implements SourceColumnChangeListener,
TransformerChangeListener {
    private final DCComboBox<InputColumn<?>> _comboBox = new DCComboBox();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Class<?> _dataType;
    private final ConfiguredPropertyDescriptor _propertyDescriptor;
    private final AbstractBeanJobBuilder<?, ?, ?> _beanJobBuilder;
    private volatile List<InputColumn<?>> _inputColumns;

    @Inject
    public SingleInputColumnComboBoxPropertyWidget(AnalysisJobBuilder analysisJobBuilder, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this._comboBox.setRenderer(new SchemaStructureComboBoxListRenderer());
        this._comboBox.addListener(new DCComboBox.Listener<InputColumn<?>>(){

            @Override
            public void onItemSelected(InputColumn<?> item) {
                SingleInputColumnComboBoxPropertyWidget.this.fireValueChanged();
            }
        });
        this._analysisJobBuilder = analysisJobBuilder;
        this._analysisJobBuilder.getSourceColumnListeners().add(this);
        this._analysisJobBuilder.getTransformerChangeListeners().add(this);
        this._beanJobBuilder = beanJobBuilder;
        this._propertyDescriptor = propertyDescriptor;
        this._dataType = propertyDescriptor.getTypeArgument(0);
        this.updateComponents();
        this.add(this._comboBox);
    }

    private void updateComponents() {
        InputColumn currentValue = (InputColumn)this.getCurrentValue();
        this.updateComponents(currentValue);
    }

    private void updateComponents(InputColumn<?> currentValue) {
        this._inputColumns = this._analysisJobBuilder.getAvailableInputColumns(this._dataType);
        if (this._beanJobBuilder instanceof TransformerJobBuilder) {
            TransformerJobBuilder tjb = (TransformerJobBuilder)this._beanJobBuilder;
            List outputColumns = tjb.getOutputColumns();
            this._inputColumns.removeAll(outputColumns);
        }
        if (currentValue != null && !this._inputColumns.contains(currentValue)) {
            this._inputColumns.add(currentValue);
        }
        if (!this._propertyDescriptor.isRequired()) {
            this._inputColumns = new ArrayList(this._inputColumns);
            this._inputColumns.add(0, null);
        }
        this._comboBox.setModel((ComboBoxModel<InputColumn<?>>)new ListComboBoxModel(this._inputColumns));
        this._comboBox.setSelectedItem(currentValue);
        this.fireValueChanged();
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        if (this._dataType == Object.class || ReflectionUtils.is((Type)sourceColumn.getDataType(), this._dataType)) {
            this.updateComponents();
            this.updateUI();
        }
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        this.handleRemovedColumn(sourceColumn);
    }

    private void handleRemovedColumn(InputColumn<?> column) {
        if (this._dataType == Object.class || ReflectionUtils.is((Type)column.getDataType(), this._dataType)) {
            InputColumn currentValue = (InputColumn)this._beanJobBuilder.getConfiguredProperty(this._propertyDescriptor);
            if (currentValue != null && currentValue.equals(column)) {
                this._beanJobBuilder.setConfiguredProperty(this._propertyDescriptor, null);
            }
            this.updateComponents();
            this.updateUI();
        }
    }

    public void onAdd(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onOutputChanged(TransformerJobBuilder<?> transformerJobBuilder, List<MutableInputColumn<?>> outputColumns) {
        this.updateComponents();
        this.updateUI();
    }

    public void onRemove(TransformerJobBuilder<?> transformerJobBuilder) {
        List outputColumns = transformerJobBuilder.getOutputColumns();
        for (MutableInputColumn column : outputColumns) {
            this.handleRemovedColumn((InputColumn<?>)column);
        }
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._analysisJobBuilder.getSourceColumnListeners().remove(this);
        this._analysisJobBuilder.getTransformerChangeListeners().remove(this);
    }

    @Override
    public InputColumn<?> getValue() {
        return this._comboBox.getSelectedItem();
    }

    public void onConfigurationChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onRequirementChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    @Override
    protected void setValue(InputColumn<?> value) {
        this.updateComponents(value);
        this.updateUI();
    }
}

