/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.analyzer.job.builder.TransformerChangeListener;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.actions.AddExpressionBasedColumnActionListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.JXRadioGroup;
import org.jdesktop.swingx.JXTextField;
import org.jdesktop.swingx.VerticalLayout;

public class SingleInputColumnRadioButtonPropertyWidget
extends AbstractPropertyWidget<InputColumn<?>>
implements SourceColumnChangeListener,
TransformerChangeListener {
    private final JXRadioGroup<JRadioButton> _radioGroup = new JXRadioGroup();
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final Class<?> _dataType;
    private final ConfiguredPropertyDescriptor _propertyDescriptor;
    private final AbstractBeanJobBuilder<?, ?, ?> _beanJobBuilder;
    private final DCPanel _buttonPanel;
    private volatile JRadioButton[] _radioButtons;
    private volatile List<InputColumn<?>> _inputColumns;
    private final JXTextField _searchDatastoreTextField;

    @Inject
    public SingleInputColumnRadioButtonPropertyWidget(AnalysisJobBuilder analysisJobBuilder, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this._radioGroup.setLayoutAxis(1);
        this._radioGroup.setOpaque(false);
        this._analysisJobBuilder = analysisJobBuilder;
        this._analysisJobBuilder.getSourceColumnListeners().add(this);
        this._analysisJobBuilder.getTransformerChangeListeners().add(this);
        this._beanJobBuilder = beanJobBuilder;
        this._propertyDescriptor = propertyDescriptor;
        this._dataType = propertyDescriptor.getTypeArgument(0);
        this._searchDatastoreTextField = WidgetFactory.createTextField("Search/filter columns");
        this._searchDatastoreTextField.setBorder(WidgetUtils.BORDER_THIN);
        this._searchDatastoreTextField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                String text = SingleInputColumnRadioButtonPropertyWidget.this._searchDatastoreTextField.getText();
                if (StringUtils.isNullOrEmpty((String)text)) {
                    for (JRadioButton rb : SingleInputColumnRadioButtonPropertyWidget.this._radioButtons) {
                        rb.setVisible(true);
                    }
                } else {
                    text = text.trim().toLowerCase();
                    JRadioButton[] arr$ = SingleInputColumnRadioButtonPropertyWidget.this._radioButtons;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        JRadioButton rb;
                        String name = (rb = arr$[i$]).getText().toLowerCase();
                        rb.setVisible(name.indexOf(text) != -1);
                    }
                }
            }
        });
        this._buttonPanel = new DCPanel();
        this._buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        if (this._dataType == String.class || this._dataType == Object.class) {
            JButton expressionColumnButton = WidgetFactory.createSmallButton("images/model/column_expression.png");
            expressionColumnButton.setToolTipText("Create expression/value based column");
            expressionColumnButton.addActionListener(AddExpressionBasedColumnActionListener.forSingleColumn(this));
            expressionColumnButton.setFocusable(false);
            this._buttonPanel.add(expressionColumnButton);
        }
        this.updateComponents();
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._searchDatastoreTextField, "North");
        outerPanel.add((Component)this._radioGroup, "Center");
        outerPanel.add((Component)this._buttonPanel, "East");
        this.add(outerPanel);
    }

    private void updateComponents() {
        InputColumn currentValue = (InputColumn)this.getCurrentValue();
        this.updateComponents(currentValue);
    }

    private void updateComponents(InputColumn<?> value) {
        this._inputColumns = this._analysisJobBuilder.getAvailableInputColumns(this._dataType);
        if (this._beanJobBuilder instanceof TransformerJobBuilder) {
            TransformerJobBuilder tjb = (TransformerJobBuilder)this._beanJobBuilder;
            List outputColumns = tjb.getOutputColumns();
            this._inputColumns.removeAll(outputColumns);
        }
        if (value != null && !this._inputColumns.contains(value)) {
            this._inputColumns.add(value);
        }
        this._searchDatastoreTextField.setVisible(this._inputColumns.size() > 5);
        this._radioButtons = this._propertyDescriptor.isRequired() ? new JRadioButton[this._inputColumns.size()] : new JRadioButton[this._inputColumns.size() + 1];
        if (this._inputColumns.isEmpty()) {
            this._radioButtons = new JRadioButton[1];
            JRadioButton radioButton = new JRadioButton("<html><font color=\"gray\">- no <i>" + LabelUtils.getDataTypeLabel(this._dataType) + "</i> columns available -</font></html>");
            radioButton.setOpaque(false);
            radioButton.setEnabled(false);
            this._radioButtons[0] = radioButton;
        } else {
            for (int i = 0; i < this._inputColumns.size(); ++i) {
                InputColumn<?> inputColumn = this._inputColumns.get(i);
                JRadioButton radioButton = new JRadioButton(inputColumn.getName());
                radioButton.setOpaque(false);
                if (value == inputColumn) {
                    radioButton.setSelected(true);
                }
                this._radioButtons[i] = radioButton;
            }
            if (!this._propertyDescriptor.isRequired()) {
                JRadioButton radioButton = new JRadioButton("(none)");
                radioButton.setOpaque(false);
                if (value == null) {
                    radioButton.setSelected(true);
                }
                this._radioButtons[this._radioButtons.length - 1] = radioButton;
            }
        }
        for (int i = 0; i < this._radioButtons.length; ++i) {
            JRadioButton rb = this._radioButtons[i];
            rb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SingleInputColumnRadioButtonPropertyWidget.this.fireValueChanged();
                }
            });
        }
        this._radioGroup.setValues((Object[])this._radioButtons);
        this.fireValueChanged();
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        if (this._dataType == Object.class || ReflectionUtils.is((Type)sourceColumn.getDataType(), this._dataType)) {
            this.updateComponents();
            this.updateUI();
        }
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        this.handleRemovedColumn(sourceColumn);
    }

    private void handleRemovedColumn(InputColumn<?> column) {
        if (this._dataType == Object.class || ReflectionUtils.is((Type)column.getDataType(), this._dataType)) {
            InputColumn currentValue = (InputColumn)this._beanJobBuilder.getConfiguredProperty(this._propertyDescriptor);
            if (currentValue != null && currentValue.equals(column)) {
                this._beanJobBuilder.setConfiguredProperty(this._propertyDescriptor, null);
            }
            this.updateComponents();
            this.updateUI();
        }
    }

    public void onAdd(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onOutputChanged(TransformerJobBuilder<?> transformerJobBuilder, List<MutableInputColumn<?>> outputColumns) {
        this.updateComponents();
        this.updateUI();
    }

    public void onRemove(TransformerJobBuilder<?> transformerJobBuilder) {
        List outputColumns = transformerJobBuilder.getOutputColumns();
        for (MutableInputColumn column : outputColumns) {
            this.handleRemovedColumn((InputColumn<?>)column);
        }
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._analysisJobBuilder.getSourceColumnListeners().remove(this);
        this._analysisJobBuilder.getTransformerChangeListeners().remove(this);
    }

    @Override
    public InputColumn<?> getValue() {
        for (int i = 0; i < this._inputColumns.size(); ++i) {
            JRadioButton radio = this._radioButtons[i];
            if (!radio.isSelected()) continue;
            return this._inputColumns.get(i);
        }
        return null;
    }

    public void onConfigurationChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    public void onRequirementChanged(TransformerJobBuilder<?> transformerJobBuilder) {
    }

    @Override
    protected void setValue(InputColumn<?> value) {
        this.updateComponents(value);
        this.updateUI();
    }
}

