/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.beans.api.NumberProperty;
import org.eobjects.analyzer.beans.convert.ConvertToNumberTransformer;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.Percentage;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;

public class SingleNumberPropertyWidget
extends AbstractPropertyWidget<Number> {
    private final boolean _primitive;
    private final JTextField _textField = new JTextField(5);

    @Inject
    public SingleNumberPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textField.setDocument(new NumberDocument(this.isDecimalAllowed(), this.isNegativeAllowed()));
        this._primitive = propertyDescriptor.getType().isPrimitive();
        Number currentValue = (Number)this.getCurrentValue();
        if (currentValue != null) {
            this._textField.setText(currentValue.toString());
        }
        this._textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                SingleNumberPropertyWidget.this.fireValueChanged();
            }
        });
        this.add(this._textField);
    }

    private boolean isNegativeAllowed() {
        NumberProperty numberProperty = (NumberProperty)this.getPropertyDescriptor().getAnnotation(NumberProperty.class);
        if (numberProperty != null) {
            return numberProperty.negative();
        }
        return true;
    }

    private boolean isDecimalAllowed() {
        Class type = this.getPropertyDescriptor().getBaseType();
        return !ReflectionUtils.isByte((Type)type) && !ReflectionUtils.isShort((Type)type) && !ReflectionUtils.isInteger((Type)type) && !ReflectionUtils.isLong((Type)type);
    }

    @Override
    public boolean isSet() {
        return this.getValue() != null;
    }

    @Override
    public Number getValue() {
        Class type;
        String text = this._textField.getText();
        if (text == null || text.length() == 0) {
            if (this._primitive) {
                text = "0";
            } else {
                return null;
            }
        }
        if (ReflectionUtils.isInteger((Type)(type = this.getPropertyDescriptor().getType()))) {
            return Integer.parseInt(text);
        }
        if (ReflectionUtils.isDouble((Type)type)) {
            return Double.parseDouble(text);
        }
        if (ReflectionUtils.isLong((Type)type)) {
            return Long.parseLong(text);
        }
        if (ReflectionUtils.isByte((Type)type)) {
            return Byte.parseByte(text);
        }
        if (ReflectionUtils.isFloat((Type)type)) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (ReflectionUtils.isShort((Type)type)) {
            return Short.parseShort(text);
        }
        if (ReflectionUtils.is((Type)type, Percentage.class)) {
            return Percentage.parsePercentage((String)text);
        }
        if (ReflectionUtils.isNumber((Type)type)) {
            return ConvertToNumberTransformer.transformValue((Object)text);
        }
        throw new IllegalStateException("Unsupported number-property type: " + type);
    }

    @Override
    protected void setValue(Number value) {
        if (value == null) {
            this._textField.setText("");
            return;
        }
        this._textField.setText(value.toString());
    }
}

