/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.Color;
import java.awt.Component;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.jdesktop.swingx.JXTextField;

public class SinglePatternPropertyWidget
extends AbstractPropertyWidget<Pattern>
implements DocumentListener {
    private final JXTextField _textField;

    @Inject
    public SinglePatternPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        this._textField = WidgetFactory.createTextField(propertyDescriptor.getName());
        this._textField.getDocument().addDocumentListener(this);
        Pattern currentValue = (Pattern)this.getCurrentValue();
        this.setValue(currentValue);
        this.updateColor();
        this.add((Component)this._textField);
    }

    @Override
    public boolean isSet() {
        return this._textField.getText() != null && this._textField.getText().length() > 0 && this.isValidPattern();
    }

    @Override
    public Pattern getValue() {
        try {
            return Pattern.compile(this._textField.getText());
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    public boolean isValidPattern() {
        try {
            Pattern.compile(this._textField.getText());
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private void updateColor() {
        if (this._textField.getText() == null || this._textField.getText().length() == 0) {
            this._textField.setBackground(Color.white);
        } else if (this.isValidPattern()) {
            this._textField.setBackground(Color.green);
            this.fireValueChanged();
        } else {
            this._textField.setBackground(Color.red);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateColor();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateColor();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateColor();
    }

    @Override
    protected void setValue(Pattern value) {
        String pattern;
        if (value != null && !(pattern = value.pattern()).equals(this._textField.getText())) {
            this._textField.setText(pattern);
        }
    }
}

