/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JButton;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.StringPatternChangeListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.ReferenceDataComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.datacleaner.windows.ReferenceDataDialog;
import org.jdesktop.swingx.HorizontalLayout;

public class SingleStringPatternPropertyWidget
extends AbstractPropertyWidget<StringPattern>
implements StringPatternChangeListener {
    private final DCComboBox<StringPattern> _comboBox;
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private final Provider<ReferenceDataDialog> _referenceDataDialogProvider;

    @Inject
    public SingleStringPatternPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, MutableReferenceDataCatalog referenceDataCatalog, Provider<ReferenceDataDialog> referenceDataDialogProvider) {
        super(beanJobBuilder, propertyDescriptor);
        String[] stringPatternNames;
        this._referenceDataCatalog = referenceDataCatalog;
        this._referenceDataDialogProvider = referenceDataDialogProvider;
        this._comboBox = new DCComboBox();
        this._comboBox.setRenderer(new ReferenceDataComboBoxListRenderer());
        this._comboBox.setEditable(false);
        if (!propertyDescriptor.isRequired()) {
            this._comboBox.addItem(null);
        }
        for (String name : stringPatternNames = referenceDataCatalog.getStringPatternNames()) {
            this._comboBox.addItem(referenceDataCatalog.getStringPattern(name));
        }
        StringPattern currentValue = (StringPattern)this.getCurrentValue();
        this._comboBox.setSelectedItem(currentValue);
        this._comboBox.addListener(new DCComboBox.Listener<StringPattern>(){

            @Override
            public void onItemSelected(StringPattern item) {
                SingleStringPatternPropertyWidget.this.fireValueChanged();
            }
        });
        JButton dialogButton = WidgetFactory.createSmallButton("images/menu/options.png");
        dialogButton.setToolTipText("Configure synonym catalogs");
        dialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog dialog = (ReferenceDataDialog)SingleStringPatternPropertyWidget.this._referenceDataDialogProvider.get();
                dialog.selectStringPatternsTab();
                dialog.setVisible(true);
            }
        });
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout((LayoutManager)new HorizontalLayout(2));
        outerPanel.add(this._comboBox);
        outerPanel.add(dialogButton);
        this.add(outerPanel);
    }

    @Override
    public void onPanelAdd() {
        super.onPanelAdd();
        this._referenceDataCatalog.addStringPatternListener(this);
    }

    @Override
    public void onPanelRemove() {
        super.onPanelRemove();
        this._referenceDataCatalog.removeStringPatternListener(this);
    }

    @Override
    public StringPattern getValue() {
        return this._comboBox.getSelectedItem();
    }

    @Override
    protected void setValue(StringPattern value) {
        this._comboBox.setEditable(true);
        this._comboBox.setSelectedItem(value);
        this._comboBox.setEditable(false);
    }

    @Override
    public void onAdd(StringPattern stringPattern) {
        this._comboBox.addItem(stringPattern);
    }

    @Override
    public void onRemove(StringPattern stringPattern) {
        this._comboBox.removeItem(stringPattern);
    }
}

