/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.eobjects.analyzer.beans.api.StringProperty;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.Func;
import org.eobjects.metamodel.util.Predicate;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;

public class SingleStringPropertyWidget
extends AbstractPropertyWidget<String> {
    private final JTextComponent _textComponent;

    @Inject
    public SingleStringPropertyWidget(ConfiguredPropertyDescriptor propertyDescriptor, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(beanJobBuilder, propertyDescriptor);
        StringProperty stringPropertyAnnotation = (StringProperty)propertyDescriptor.getAnnotation(StringProperty.class);
        this._textComponent = this.getTextComponent(propertyDescriptor, stringPropertyAnnotation);
        String currentValue = (String)this.getCurrentValue();
        if (currentValue != null) {
            this._textComponent.setText(currentValue);
        }
        this.add(this._textComponent);
    }

    protected JTextComponent getTextComponent(ConfiguredPropertyDescriptor propertyDescriptor, StringProperty stringPropertyAnnotation) {
        JPasswordField textComponent;
        boolean password;
        String mimeType;
        boolean multiline;
        if (stringPropertyAnnotation == null) {
            multiline = false;
            mimeType = null;
            password = false;
        } else {
            multiline = stringPropertyAnnotation.multiline();
            String[] mimeTypes = stringPropertyAnnotation.mimeType();
            mimeType = this.getTextAreaMimeType(mimeTypes);
            password = stringPropertyAnnotation.password();
        }
        if (multiline) {
            if (mimeType != null) {
                RSyntaxTextArea syntaxArea = new RSyntaxTextArea(8, 17);
                syntaxArea.setSyntaxEditingStyle(mimeType);
                textComponent = syntaxArea;
            } else {
                textComponent = WidgetFactory.createTextArea(propertyDescriptor.getName());
            }
        } else {
            textComponent = password ? WidgetFactory.createPasswordField() : WidgetFactory.createTextField(propertyDescriptor.getName());
        }
        textComponent.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                SingleStringPropertyWidget.this.fireValueChanged();
            }
        });
        return textComponent;
    }

    private String getTextAreaMimeType(String[] mimeTypes) {
        if (mimeTypes == null) {
            return null;
        }
        List fields = Arrays.asList(SyntaxConstants.class.getFields());
        fields = CollectionUtils.filter(fields, (Predicate)new Predicate<Field>(){

            public Boolean eval(Field f) {
                if (f.getName().startsWith("SYNTAX_STYLE_") && f.getType() == String.class) {
                    int modifiers = f.getModifiers();
                    boolean accessible = f.isAccessible() || Modifier.isPublic(modifiers);
                    boolean isStatic = Modifier.isStatic(modifiers);
                    return accessible && isStatic;
                }
                return false;
            }
        });
        List acceptedMimeTypes = CollectionUtils.map((Iterable)fields, (Func)new Func<Field, String>(){

            public String eval(Field f) {
                try {
                    return (String)f.get(null);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
        for (String mimeType : mimeTypes) {
            if (!acceptedMimeTypes.contains(mimeType)) continue;
            return mimeType;
        }
        return null;
    }

    @Override
    public boolean isSet() {
        return this._textComponent.getText() != null && this._textComponent.getText().length() > 0;
    }

    @Override
    public String getValue() {
        return this._textComponent.getText();
    }

    @Override
    protected void setValue(String value) {
        this._textComponent.setText(value);
    }
}

