/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.properties;

import javax.swing.DefaultComboBoxModel;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SchemaStructureComboBoxListRenderer;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.schema.MutableTable;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.MutableRef;

public class TableNamePropertyWidget
extends AbstractPropertyWidget<String> {
    private final DCComboBox<Table> _comboBox = new DCComboBox();
    private final MutableRef<Schema> _schemaRef;

    public TableNamePropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this._comboBox.setRenderer(new SchemaStructureComboBoxListRenderer(false));
        this._comboBox.setEditable(false);
        this.addComboListener(new DCComboBox.Listener<Table>(){

            @Override
            public void onItemSelected(Table item) {
                TableNamePropertyWidget.this.fireValueChanged();
            }
        });
        this.add(this._comboBox);
        this._schemaRef = new MutableRef();
        this.setValue((String)this.getCurrentValue());
    }

    public void addComboListener(DCComboBox.Listener<Table> listener) {
        this._comboBox.addListener(listener);
    }

    public void setSchema(Schema schema) {
        String previousValue = this.getValue();
        this._schemaRef.set((Object)schema);
        if (schema == null) {
            this._comboBox.setModel(new DefaultComboBoxModel<Object>(new Object[1]));
        } else {
            Object[] tables = schema.getTables();
            tables = (Table[])CollectionUtils.array((Object[])new Table[1], (Object[])tables);
            this._comboBox.setModel(new DefaultComboBoxModel<Object>(tables));
            if (previousValue == null) {
                if (schema.getTableCount() == 1) {
                    Table table = schema.getTables()[0];
                    this._comboBox.setSelectedItem(table);
                }
            } else {
                Table table = schema.getTableByName(previousValue);
                this._comboBox.setSelectedItem(table);
            }
        }
    }

    @Override
    public String getValue() {
        Table table = this.getTable();
        if (table == null) {
            return null;
        }
        return table.getName();
    }

    public Table getTable() {
        return this._comboBox.getSelectedItem();
    }

    @Override
    protected void setValue(String value) {
        if (this.getValue() == value) {
            return;
        }
        Schema schema = (Schema)this._schemaRef.get();
        Object table = value == null ? null : (schema == null ? new MutableTable(value) : schema.getTableByName(value));
        this._comboBox.setEditable(true);
        this._comboBox.setSelectedItem(table);
        this._comboBox.setEditable(false);
    }
}

