/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.math.NumberUtils;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabDimension;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.ResultProducer;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.CrosstabRenderer;
import org.eobjects.analyzer.result.renderer.CrosstabRendererCallback;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ChartUtils;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.result.DisplayChartCallback;
import org.eobjects.datacleaner.widgets.result.DrillToDetailsCallback;
import org.eobjects.datacleaner.widgets.result.DrillToDetailsCallbackImpl;
import org.eobjects.datacleaner.widgets.table.CrosstabPanel;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class AbstractCrosstabResultSwingRenderer<R extends CrosstabResult>
extends AbstractRenderer<R, JComponent> {
    public static final String IMAGE_PATH_BAR_CHART = "images/chart-types/bar.png";
    public static final String IMAGE_PATH_DRILL_TO_DETAIL = "images/actions/drill-to-detail.png";
    @Inject
    @Provided
    WindowContext _windowContext;
    @Inject
    @Provided
    RendererFactory _rendererFactory;
    private DrillToDetailsCallback _drillToDetailsCallback;

    public AbstractCrosstabResultSwingRenderer(WindowContext windowContext, RendererFactory rendererFactory) {
        this._windowContext = windowContext;
        this._rendererFactory = rendererFactory;
    }

    public AbstractCrosstabResultSwingRenderer() {
    }

    public JComponent render(R result) {
        return this.renderInternal(result);
    }

    public RendererFactory getRendererFactory() {
        return this._rendererFactory;
    }

    @Deprecated
    protected CrosstabPanel renderInternal(R result, boolean allowAnimations) {
        return this.renderInternal(result);
    }

    protected CrosstabPanel renderInternal(R result) {
        this._drillToDetailsCallback = new DrillToDetailsCallbackImpl(this._windowContext, this.getRendererFactory());
        DCTable table = this.renderTable(result.getCrosstab());
        CrosstabPanel crosstabPanel = new CrosstabPanel(table);
        this.decorate(result, table, crosstabPanel.getDisplayChartCallback());
        table.packColumn(0, 2);
        return crosstabPanel;
    }

    protected void decorate(R result, DCTable table, DisplayChartCallback displayChartCallback) {
        if (result.getCrosstab().getDimensionCount() == 2 && table.getColumnCount() > 2) {
            this.addDefaultBarCharts(table, displayChartCallback);
        }
    }

    protected void addDefaultBarCharts(DCTable table, DisplayChartCallback displayChartCallback) {
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            Object firstRowCell;
            boolean entirelyNumbers = true;
            for (int j = 1; j < columnCount; ++j) {
                String value = table.getTextValueAt(i, j);
                if (NumberUtils.isNumber((String)value)) continue;
                entirelyNumbers = false;
                break;
            }
            if (!entirelyNumbers || !((firstRowCell = table.getValueAt(i, 0)) instanceof String)) continue;
            String measureName = firstRowCell.toString();
            this.addDefaultBarChart(table, displayChartCallback, i, measureName);
        }
    }

    protected void addDefaultBarChart(final DCTable table, final DisplayChartCallback displayChartCallback, final int row, final String measureName) {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                int columnCount = table.getColumnCount();
                for (int j = 1; j < columnCount; ++j) {
                    String textValue = table.getTextValueAt(row, j);
                    Number value = NumberUtils.createNumber((String)textValue);
                    dataset.setValue(value, (Comparable)((Object)table.getColumnName(j)), (Comparable)((Object)""));
                }
                JFreeChart chart = ChartFactory.createBarChart((String)"", (String)"", (String)measureName, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                ChartUtils.applyStyles(chart);
                ChartPanel chartPanel = new ChartPanel(chart);
                displayChartCallback.displayChart((JComponent)chartPanel);
            }
        };
        DCPanel panel = AbstractCrosstabResultSwingRenderer.createActionableValuePanel(measureName, Alignment.LEFT, action, IMAGE_PATH_BAR_CHART);
        table.setValueAt(panel, row, 0);
    }

    private DCTable renderTable(Crosstab<?> crosstab) {
        CrosstabRenderer renderer = new CrosstabRenderer(crosstab);
        RendererCallback rendererCallback = new RendererCallback();
        TableModel tableModel = (TableModel)renderer.render((CrosstabRendererCallback)rendererCallback);
        Alignment alignment = rendererCallback.getAlignment();
        DCTable table = new DCTable(tableModel);
        table.setSortable(false);
        table.setAlignment(0, Alignment.LEFT);
        int columnCount = table.getColumnCount();
        for (int i = 1; i < columnCount; ++i) {
            table.setAlignment(i, alignment);
        }
        table.autoSetHorizontalScrollEnabled();
        table.setRowHeight(22);
        return table;
    }

    protected void horizontalHeaderCell(String category, TableModel tableModel, int row, int col) {
        if (row >= 0) {
            tableModel.setValueAt(AbstractCrosstabResultSwingRenderer.getLabelText(category), row, col);
        }
    }

    protected void verticalHeaderCell(String category, TableModel tableModel, int row, int col) {
        if (row >= 0) {
            tableModel.setValueAt(AbstractCrosstabResultSwingRenderer.getLabelText(category), row, col);
        }
    }

    protected void valueCell(Object value, final ResultProducer drillToDetailResultProducer, TableModel tableModel, int row, int col, boolean headersIncluded, Alignment alignment) {
        Object resultValue;
        ActionListener action = null;
        if (drillToDetailResultProducer != null) {
            final StringBuilder sb = new StringBuilder("Detailed result for [");
            sb.append(AbstractCrosstabResultSwingRenderer.getLabelText(value));
            sb.append(" (");
            String cat1 = headersIncluded ? tableModel.getColumnName(col) : tableModel.getValueAt(0, col).toString();
            sb.append(cat1).append(", ");
            String cat2 = tableModel.getValueAt(row, 0).toString();
            sb.append(cat2);
            sb.append(")]");
            action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractCrosstabResultSwingRenderer.this._drillToDetailsCallback.drillToDetails(sb.toString(), drillToDetailResultProducer);
                }
            };
            resultValue = AbstractCrosstabResultSwingRenderer.createActionableValuePanel(value, alignment, action, IMAGE_PATH_DRILL_TO_DETAIL);
        } else {
            resultValue = AbstractCrosstabResultSwingRenderer.getLabelText(value);
        }
        tableModel.setValueAt(resultValue, row, col);
    }

    private static String getLabelText(Object value) {
        if (value == null) {
            return "<null>";
        }
        if ("".equals(value)) {
            return "<blank>";
        }
        if (value instanceof Double || value instanceof Float) {
            return NumberFormat.getInstance().format(value);
        }
        return value.toString();
    }

    public static DCPanel createActionableValuePanel(Object value, Alignment alignment, ActionListener action, String iconImagePath) {
        JLabel label = new JLabel(AbstractCrosstabResultSwingRenderer.getLabelText(value));
        DCPanel panel = new DCPanel();
        panel.add(label);
        panel.setLayout(new FlowLayout(alignment.getFlowLayoutAlignment(), 0, 0));
        if (action != null && iconImagePath != null) {
            JButton button = WidgetFactory.createSmallButton(iconImagePath);
            button.addActionListener(action);
            panel.add(Box.createHorizontalStrut(4));
            panel.add(button);
        }
        return panel;
    }

    private final class RendererCallback
    implements CrosstabRendererCallback<TableModel> {
        private boolean headersIncluded;
        private TableModel _tableModel;
        private int _row = 0;
        private int _col = 0;
        private Alignment _alignment = Alignment.LEFT;

        private RendererCallback() {
        }

        public void beginTable(Crosstab<?> crosstab, List<CrosstabDimension> horizontalDimensions, List<CrosstabDimension> verticalDimensions) {
            int rows = 1;
            int cols = 1;
            for (CrosstabDimension crosstabDimension : verticalDimensions) {
                rows *= crosstabDimension.getCategoryCount();
            }
            rows += horizontalDimensions.size();
            for (CrosstabDimension crosstabDimension : horizontalDimensions) {
                cols *= crosstabDimension.getCategoryCount();
            }
            Object[] columnNames = new String[cols += verticalDimensions.size()];
            if (horizontalDimensions.size() == 1) {
                this.headersIncluded = true;
                CrosstabDimension horizontalDimension = horizontalDimensions.get(0);
                List categories = horizontalDimension.getCategories();
                columnNames[0] = "";
                for (int i = 1; i < columnNames.length; ++i) {
                    columnNames[i] = (String)categories.get(i - 1);
                }
                --rows;
                --this._row;
            } else {
                this.headersIncluded = false;
                for (int i = 0; i < columnNames.length; ++i) {
                    columnNames[i] = "";
                }
            }
            this._tableModel = new DefaultTableModel(columnNames, rows);
            if (ReflectionUtils.isNumber((Type)crosstab.getValueClass())) {
                this._alignment = Alignment.RIGHT;
            }
        }

        public Alignment getAlignment() {
            return this._alignment;
        }

        public void endTable() {
        }

        public void beginRow() {
        }

        public void endRow() {
            ++this._row;
            this._col = 0;
        }

        public void horizontalHeaderCell(String category, CrosstabDimension dimension, int width) {
            AbstractCrosstabResultSwingRenderer.this.horizontalHeaderCell(category, this._tableModel, this._row, this._col);
            ++this._col;
        }

        public void verticalHeaderCell(String category, CrosstabDimension dimension, int height) {
            AbstractCrosstabResultSwingRenderer.this.verticalHeaderCell(category, this._tableModel, this._row, this._col);
            ++this._col;
        }

        public void valueCell(Object value, ResultProducer drillToDetailResultProducer) {
            AbstractCrosstabResultSwingRenderer.this.valueCell(value, drillToDetailResultProducer, this._tableModel, this._row, this._col, this.headersIncluded, this._alignment);
            ++this._col;
        }

        public TableModel getResult() {
            return this._tableModel;
        }

        public void emptyHeader(CrosstabDimension verticalDimension, CrosstabDimension horizontalDimension) {
            if (this._row >= 0) {
                this._tableModel.setValueAt("", this._row, this._col);
            }
            ++this._col;
        }
    }
}

