/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.awt.LayoutManager;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.eobjects.analyzer.beans.api.Description;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.ReflectionUtils;
import org.eobjects.datacleaner.actions.SaveDataSetActionListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UsageLogger;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.table.ColumnHighlighter;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.decorator.Highlighter;

@RendererBean(value=SwingRenderingFormat.class)
public class AnnotatedRowsResultSwingRenderer
extends AbstractRenderer<AnnotatedRowsResult, DCPanel> {
    private static final String[] VIEWS = new String[]{"View detailed rows", "View distinct values"};
    @Inject
    UserPreferences userPreferences;
    @Inject
    DatastoreCatalog datastoreCatalog;
    @Inject
    UsageLogger usageLogger;

    public AnnotatedRowResultPanel render(AnnotatedRowsResult result) {
        AnnotatedRowResultPanel panel = new AnnotatedRowResultPanel(result, this.usageLogger, this.userPreferences, this.datastoreCatalog);
        return panel;
    }

    public static class AnnotatedRowResultPanel
    extends DCPanel {
        private static final long serialVersionUID = 1L;
        private final AnnotatedRowsResult _result;
        private final UsageLogger _usageLogger;
        private final UserPreferences _userPreferences;
        private final DatastoreCatalog _datastoreCatalog;
        private final DCTable _table;

        public AnnotatedRowResultPanel(AnnotatedRowsResult result, UsageLogger usageLogger, UserPreferences userPreferences, DatastoreCatalog datastoreCatalog) {
            this._result = result;
            this._usageLogger = usageLogger;
            this._userPreferences = userPreferences;
            this._datastoreCatalog = datastoreCatalog;
            this.setLayout((LayoutManager)new VerticalLayout(4));
            this._table = new DCTable();
            this._table.setColumnControlVisible(false);
            InputColumn[] highlightedColumns = result.getHighlightedColumns();
            List inputColumns = result.getInputColumns();
            JToolBar buttonToolBar = WidgetFactory.createToolBar();
            buttonToolBar.setBorder(new EmptyBorder(0, 4, 0, 4));
            Description description = (Description)ReflectionUtils.getAnnotation(result.getClass(), Description.class);
            String descriptionText = description != null ? description.value() : "Records";
            int annotatedRowCount = result.getAnnotation().getRowCount();
            DCLabel label = DCLabel.dark(descriptionText + " (" + result.getAnnotatedRowCount() + ")");
            label.setFont(WidgetUtils.FONT_HEADER1);
            buttonToolBar.add(label);
            buttonToolBar.add(WidgetFactory.createToolBarSeparator());
            if (highlightedColumns.length == 1 && inputColumns.size() > 1) {
                DCComboBox<String> comboBox = new DCComboBox<String>(VIEWS);
                comboBox.addListener(new DCComboBox.Listener<String>(){

                    @Override
                    public void onItemSelected(String item) {
                        if (item == VIEWS[0]) {
                            AnnotatedRowResultPanel.this.applyDetailedView();
                        } else {
                            AnnotatedRowResultPanel.this.applyDistinctValuesView();
                        }
                    }
                });
                comboBox.setSelectedItem(VIEWS[0]);
                comboBox.notifyListeners();
                buttonToolBar.add(comboBox);
            } else {
                this.applyDetailedView();
            }
            JButton saveToFileButton = new JButton("Save dataset", ImageManager.getInstance().getImageIcon("images/actions/save.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]));
            saveToFileButton.addActionListener(new SaveDataSetActionListener(result.getInputColumns(), result.getRows(), this._userPreferences, this._datastoreCatalog, this._usageLogger));
            buttonToolBar.add(saveToFileButton);
            this.add(buttonToolBar);
            if (annotatedRowCount == 0) {
                DCLabel noRecordsLabel = DCLabel.dark("No records to display.");
                noRecordsLabel.setBorder(new EmptyBorder(0, 4, 0, 0));
                this.add(noRecordsLabel);
            } else {
                this.add(this._table.toPanel());
            }
        }

        public void applyDistinctValuesView() {
            InputColumn[] highlightedColumns = this._result.getHighlightedColumns();
            TableModel tableModel = this._result.toDistinctValuesTableModel(highlightedColumns[0]);
            this._table.setModel(tableModel);
            this._table.autoSetHorizontalScrollEnabled();
            this._table.setHighlighters(new Highlighter[0]);
        }

        public void applyDetailedView() {
            this._table.setModel(this._result.toTableModel());
            this._table.autoSetHorizontalScrollEnabled();
            InputColumn[] highlightedColumns = this._result.getHighlightedColumns();
            List inputColumns = this._result.getInputColumns();
            if (inputColumns.size() > highlightedColumns.length && highlightedColumns.length > 0) {
                int[] highligthedColumnIndexes = new int[highlightedColumns.length];
                for (int i = 0; i < highligthedColumnIndexes.length; ++i) {
                    highligthedColumnIndexes[i] = this._result.getColumnIndex(highlightedColumns[i]);
                }
                this._table.addHighlighter(new ColumnHighlighter(highligthedColumnIndexes));
            }
        }

        public DCTable getTable() {
            return this._table;
        }

        public AnnotatedRowsResult getResult() {
            return this._result;
        }
    }
}

