/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.convert.ConvertToStringTransformer;
import org.eobjects.analyzer.beans.dategap.DateGapAnalyzer;
import org.eobjects.analyzer.beans.dategap.DateGapAnalyzerResult;
import org.eobjects.analyzer.beans.dategap.TimeInterval;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.analyzer.job.runner.AnalysisResultFuture;
import org.eobjects.analyzer.job.runner.AnalysisRunnerImpl;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ChartUtils;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.result.DCDrawingSupplier;
import org.eobjects.datacleaner.windows.DetailsResultWindow;
import org.eobjects.metamodel.schema.Table;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.SlidingGanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RendererBean(value=SwingRenderingFormat.class)
public class DateGapAnalyzerResultSwingRenderer
extends AbstractRenderer<DateGapAnalyzerResult, JComponent> {
    private static final Logger logger = LoggerFactory.getLogger(DateGapAnalyzerResultSwingRenderer.class);
    private static final String LABEL_OVERLAPS = "Overlaps";
    private static final String LABEL_GAPS = "Gaps";
    private static final String LABEL_COMPLETE_DURATION = "Complete duration";
    private static final int GROUPS_VISIBLE = 6;

    public JComponent render(DateGapAnalyzerResult result) {
        Object decoratedChartPanel;
        TaskSeriesCollection dataset = new TaskSeriesCollection();
        Set groupNames = result.getGroupNames();
        TaskSeries completeDurationTaskSeries = new TaskSeries(LABEL_COMPLETE_DURATION);
        TaskSeries gapsTaskSeries = new TaskSeries(LABEL_GAPS);
        TaskSeries overlapsTaskSeries = new TaskSeries(LABEL_OVERLAPS);
        for (String groupName : groupNames) {
            Task task;
            TimePeriod timePeriod;
            String groupDisplayName = groupName == null ? (groupNames.size() == 1 ? "All" : "<null>") : groupName;
            TimeInterval completeDuration = result.getCompleteDuration(groupName);
            Task completeDurationTask = new Task(groupDisplayName, this.createTimePeriod(completeDuration.getFrom(), completeDuration.getTo()));
            completeDurationTaskSeries.add(completeDurationTask);
            SortedSet gaps = result.getGaps(groupName);
            int i = 1;
            Task rootTask = null;
            for (TimeInterval interval : gaps) {
                timePeriod = this.createTimePeriod(interval.getFrom(), interval.getTo());
                if (rootTask == null) {
                    rootTask = new Task(groupDisplayName, timePeriod);
                    gapsTaskSeries.add(rootTask);
                } else {
                    task = new Task(groupDisplayName + " gap" + i, timePeriod);
                    rootTask.addSubtask(task);
                }
                ++i;
            }
            SortedSet overlaps = result.getOverlaps(groupName);
            i = 1;
            rootTask = null;
            for (TimeInterval interval : overlaps) {
                timePeriod = this.createTimePeriod(interval.getFrom(), interval.getTo());
                if (rootTask == null) {
                    rootTask = new Task(groupDisplayName, timePeriod);
                    overlapsTaskSeries.add(rootTask);
                } else {
                    task = new Task(groupDisplayName + " overlap" + i, timePeriod);
                    rootTask.addSubtask(task);
                }
                ++i;
            }
        }
        dataset.add(overlapsTaskSeries);
        dataset.add(gapsTaskSeries);
        dataset.add(completeDurationTaskSeries);
        final SlidingGanttCategoryDataset slidingDataset = new SlidingGanttCategoryDataset((GanttCategoryDataset)dataset, 0, 6);
        JFreeChart chart = ChartFactory.createGanttChart((String)("Date gaps and overlaps in " + result.getFromColumnName() + " / " + result.getToColumnName()), (String)result.getGroupColumnName(), (String)"Time", (IntervalCategoryDataset)slidingDataset, (boolean)true, (boolean)true, (boolean)false);
        ChartUtils.applyStyles(chart);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setDrawingSupplier((DrawingSupplier)new DCDrawingSupplier(WidgetUtils.ADDITIONAL_COLOR_GREEN_BRIGHT, WidgetUtils.ADDITIONAL_COLOR_RED_BRIGHT, WidgetUtils.BG_COLOR_BLUE_BRIGHT));
        final ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseMoved(ChartMouseEvent event) {
                Cursor cursor = Cursor.getPredefinedCursor(0);
                ChartEntity entity = event.getEntity();
                if (entity instanceof PlotEntity) {
                    cursor = Cursor.getPredefinedCursor(11);
                }
                chartPanel.setCursor(cursor);
            }

            public void chartMouseClicked(ChartMouseEvent event) {
            }
        });
        int visibleLines = Math.min(6, groupNames.size());
        chartPanel.setPreferredSize(new Dimension(0, visibleLines * 50 + 200));
        StringBuilder chartDescription = new StringBuilder();
        chartDescription.append("<html><p>The chart displays the recorded timeline based on FROM and TO dates.<br/><br/>");
        chartDescription.append("The <b>red items</b> represent gaps in the timeline and the <b>green items</b> represent points in the timeline where more than one record show activity.<br/><br/>");
        chartDescription.append("You can <b>zoom in</b> by clicking and dragging the area that you want to examine in further detail.");
        if (groupNames.size() > 6) {
            final JScrollBar scroll = new JScrollBar(1);
            scroll.setMinimum(0);
            scroll.setMaximum(groupNames.size());
            scroll.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    int value = e.getAdjustable().getValue();
                    slidingDataset.setFirstCategoryIndex(value);
                }
            });
            chartPanel.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int scrollType = e.getScrollType();
                    if (scrollType == 0) {
                        int wheelRotation = e.getWheelRotation();
                        scroll.setValue(scroll.getValue() + wheelRotation);
                    }
                }
            });
            DCPanel outerPanel = new DCPanel();
            outerPanel.setLayout(new BorderLayout());
            outerPanel.add((Component)chartPanel, "Center");
            outerPanel.add((Component)scroll, "East");
            chartDescription.append("<br/><br/>Use the right <b>scrollbar</b> to scroll up and down on the chart.");
            decoratedChartPanel = outerPanel;
        } else {
            decoratedChartPanel = chartPanel;
        }
        chartDescription.append("</p></html>");
        JLabel chartDescriptionLabel = new JLabel(chartDescription.toString());
        chartDescriptionLabel.setBorder(new EmptyBorder(4, 10, 4, 10));
        JSplitPane split = new JSplitPane(1);
        split.add((Component)decoratedChartPanel);
        split.add(chartDescriptionLabel);
        split.setDividerLocation(550);
        return split;
    }

    private TimePeriod createTimePeriod(long from, long to) {
        if (from > to) {
            logger.warn("An illegal from/to combination occurred: {}, {}", (Object)from, (Object)to);
        }
        return new SimpleTimePeriod(from, to);
    }

    public static void main(String[] args) throws Throwable {
        LookAndFeelManager.getInstance().init();
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(VFSUtils.getFileSystemManager().resolveFile("."), null)});
        AnalysisJobBuilder ajb = (AnalysisJobBuilder)injector.getInstance(AnalysisJobBuilder.class);
        Datastore ds = ((DatastoreCatalog)injector.getInstance(DatastoreCatalog.class)).getDatastore("orderdb");
        ajb.setDatastore(ds);
        AnalyzerBeansConfiguration conf = (AnalyzerBeansConfiguration)injector.getInstance(AnalyzerBeansConfiguration.class);
        AnalysisRunnerImpl runner = new AnalysisRunnerImpl(conf);
        DatastoreConnection con = ds.openConnection();
        Table table = con.getSchemaNavigator().convertToTable("PUBLIC.ORDERS");
        ajb.addSourceColumn(table.getColumnByName("ORDERDATE"));
        ajb.addSourceColumn(table.getColumnByName("SHIPPEDDATE"));
        ajb.addSourceColumn(table.getColumnByName("CUSTOMERNUMBER"));
        InputColumn orderDateColumn = ajb.getSourceColumnByName("ORDERDATE");
        InputColumn shippedDateColumn = ajb.getSourceColumnByName("SHIPPEDDATE");
        InputColumn customerNumberColumn = ajb.getSourceColumnByName("CUSTOMERNUMBER");
        MutableInputColumn customerNumberAsStringColumn = (MutableInputColumn)((TransformerJobBuilder)ajb.addTransformer(ConvertToStringTransformer.class).addInputColumn(customerNumberColumn)).getOutputColumns().get(0);
        DateGapAnalyzer dga = (DateGapAnalyzer)ajb.addAnalyzer(DateGapAnalyzer.class).getConfigurableBean();
        dga.setFromColumn(orderDateColumn);
        dga.setToColumn(shippedDateColumn);
        dga.setGroupColumn((InputColumn)customerNumberAsStringColumn);
        AnalysisResultFuture resultFuture = runner.run(ajb.toAnalysisJob());
        if (resultFuture.isErrornous()) {
            throw (Throwable)resultFuture.getErrors().get(0);
        }
        List<AnalyzerResult> list = Collections.emptyList();
        RendererFactory rendererFactory = new RendererFactory(conf);
        DetailsResultWindow window = new DetailsResultWindow("Example", list, (WindowContext)injector.getInstance(WindowContext.class), rendererFactory);
        window.setDefaultCloseOperation(3);
        List results = resultFuture.getResults();
        for (AnalyzerResult analyzerResult : results) {
            JComponent renderedResult = new DateGapAnalyzerResultSwingRenderer().render((DateGapAnalyzerResult)analyzerResult);
            window.addRenderedResult(renderedResult);
        }
        window.repaint();
        window.setPreferredSize(new Dimension(800, 600));
        window.setVisible(true);
    }
}

