/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComponent;
import org.eobjects.analyzer.beans.NumberAnalyzer;
import org.eobjects.analyzer.beans.NumberAnalyzerResult;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabNavigator;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ChartUtils;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.result.AbstractCrosstabResultSwingRenderer;
import org.eobjects.datacleaner.widgets.result.DisplayChartCallback;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.ResultWindow;
import org.eobjects.metamodel.schema.Table;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.NormalDistributionFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

@RendererBean(value=SwingRenderingFormat.class)
public class NumberAnalyzerResultSwingRenderer
extends AbstractCrosstabResultSwingRenderer<NumberAnalyzerResult> {
    @Override
    protected void decorate(NumberAnalyzerResult result, DCTable table, final DisplayChartCallback displayChartCallback) {
        int rowNumber = -1;
        for (int i = 0; i < table.getRowCount(); ++i) {
            Object value = table.getValueAt(i, 0);
            if (!"Standard deviation".equals(value)) continue;
            rowNumber = i;
            break;
        }
        if (rowNumber == -1) {
            throw new IllegalStateException("Could not determine Std. deviation row number!");
        }
        Crosstab crosstab = result.getCrosstab();
        InputColumn[] columns = result.getColumns();
        int columnNumber = 1;
        for (final InputColumn column : columns) {
            Number standardDeviation;
            final CrosstabNavigator nav = crosstab.where("Column", column.getName());
            Number numRows = (Number)nav.where("Measure", "Row count").get();
            if (numRows.intValue() > 0 && (standardDeviation = (Number)nav.where("Measure", "Standard deviation").get()) != null) {
                ActionListener action = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Number mean = (Number)nav.where("Measure", "Mean").get();
                        Number min = (Number)nav.where("Measure", "Lowest value").get();
                        Number max = (Number)nav.where("Measure", "Highest value").get();
                        NormalDistributionFunction2D normalDistributionFunction = new NormalDistributionFunction2D(mean.doubleValue(), standardDeviation.doubleValue());
                        XYDataset dataset = DatasetUtilities.sampleFunction2D((Function2D)normalDistributionFunction, (double)min.doubleValue(), (double)max.doubleValue(), (int)100, (Comparable)((Object)"Normal"));
                        JFreeChart chart = ChartFactory.createXYLineChart((String)("Normal distribution of " + column.getName()), (String)column.getName(), (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        ChartUtils.applyStyles(chart);
                        ValueMarker meanMarker = new ValueMarker(mean.doubleValue(), (Paint)WidgetUtils.BG_COLOR_BLUE_DARK, (Stroke)new BasicStroke(2.0f));
                        meanMarker.setLabel("Mean");
                        meanMarker.setLabelOffset(new RectangleInsets(70.0, 25.0, 0.0, 0.0));
                        meanMarker.setLabelFont(WidgetUtils.FONT_SMALL);
                        chart.getXYPlot().addDomainMarker((Marker)meanMarker);
                        ChartPanel chartPanel = new ChartPanel(chart);
                        displayChartCallback.displayChart((JComponent)chartPanel);
                    }
                };
                DCPanel panel = AbstractCrosstabResultSwingRenderer.createActionableValuePanel(standardDeviation, Alignment.RIGHT, action, "images/chart-types/line.png");
                table.setValueAt(panel, rowNumber, columnNumber);
            }
            ++columnNumber;
        }
        super.decorate(result, table, displayChartCallback);
    }

    public static void main(String[] args) throws Exception {
        LookAndFeelManager.getInstance().init();
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(VFSUtils.getFileSystemManager().resolveFile("."), null)});
        AnalysisJobBuilder ajb = (AnalysisJobBuilder)injector.getInstance(AnalysisJobBuilder.class);
        Datastore ds = ((DatastoreCatalog)injector.getInstance(DatastoreCatalog.class)).getDatastore("orderdb");
        DatastoreConnection con = ds.openConnection();
        Table table = con.getSchemaNavigator().convertToTable("PUBLIC.CUSTOMERS");
        ajb.setDatastore(ds);
        ajb.addSourceColumns(table.getNumberColumns());
        ajb.addAnalyzer(NumberAnalyzer.class).addInputColumns((Collection)ajb.getSourceColumns());
        ResultWindow resultWindow = (ResultWindow)injector.getInstance(ResultWindow.class);
        resultWindow.setVisible(true);
        resultWindow.startAnalysis();
    }
}

