/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.stringpattern.PatternFinderAnalyzer;
import org.eobjects.analyzer.beans.stringpattern.PatternFinderResult;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.result.Crosstab;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCCollapsiblePanel;
import org.eobjects.datacleaner.widgets.result.PatternFinderResultSwingRendererCrosstabDelegate;
import org.eobjects.datacleaner.windows.ResultWindow;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RendererBean(value=SwingRenderingFormat.class)
public class PatternFinderResultSwingRenderer
extends AbstractRenderer<PatternFinderResult, JComponent> {
    private static final Logger logger = LoggerFactory.getLogger(PatternFinderResultSwingRenderer.class);
    private static final int MAX_EXPANDED_GROUPS = 30;
    @Inject
    WindowContext windowContext;
    @Inject
    RendererFactory rendererFactory;
    @Inject
    ReferenceDataCatalog referenceDataCatalog;
    private PatternFinderResultSwingRendererCrosstabDelegate delegateRenderer;

    public JComponent render(PatternFinderResult result) {
        this.delegateRenderer = new PatternFinderResultSwingRendererCrosstabDelegate(this.windowContext, this.rendererFactory, (MutableReferenceDataCatalog)this.referenceDataCatalog);
        if (result.isGroupingEnabled()) {
            return this.renderGroupedResult(result);
        }
        Crosstab singleCrosstab = result.getSingleCrosstab();
        return this.renderCrosstab(singleCrosstab);
    }

    public JComponent renderGroupedResult(PatternFinderResult result) {
        DCPanel panel = new DCPanel();
        panel.setLayout((LayoutManager)new VerticalLayout(0));
        Map crosstabs = result.getGroupedCrosstabs();
        boolean collapsed = false;
        if (crosstabs.size() > 30) {
            collapsed = true;
        }
        Set entries = crosstabs.entrySet();
        for (Map.Entry entry : entries) {
            String expandedLabel;
            final String groupName = (String)entry.getKey();
            if (panel.getComponentCount() != 0) {
                panel.add(Box.createVerticalStrut(10));
            }
            final Crosstab crosstab = (Crosstab)entry.getValue();
            LazyRef<JComponent> componentRef = new LazyRef<JComponent>(){

                protected JComponent fetch() {
                    logger.info("Rendering group result '{}'", (Object)groupName);
                    JComponent renderedResult = PatternFinderResultSwingRenderer.this.delegateRenderer.render(new CrosstabResult(crosstab));
                    DCPanel decoratedPanel = PatternFinderResultSwingRenderer.this.createDecoration(renderedResult);
                    return decoratedPanel;
                }
            };
            int patternCount = crosstab.getDimension(crosstab.getDimensionIndex("Pattern")).getCategoryCount();
            String collapsedLabel = expandedLabel = (patternCount == 1 ? "1 pattern" : patternCount + " patterns") + " in group '" + LabelUtils.getLabel((String)((String)entry.getKey() + "'"));
            DCCollapsiblePanel collapsiblePanel = new DCCollapsiblePanel(collapsedLabel, expandedLabel, collapsed, (Ref<? extends JComponent>)componentRef);
            panel.add(collapsiblePanel.toPanel());
        }
        return panel;
    }

    private DCPanel createDecoration(JComponent renderedResult) {
        renderedResult.setBorder(WidgetUtils.BORDER_SHADOW);
        DCPanel wrappingPanel = new DCPanel();
        wrappingPanel.setLayout(new BorderLayout());
        wrappingPanel.add((Component)renderedResult, "Center");
        wrappingPanel.setBorder(new EmptyBorder(4, 20, 4, 4));
        return wrappingPanel;
    }

    public JComponent renderCrosstab(Crosstab<?> crosstab) {
        CrosstabResult crosstabResult = new CrosstabResult(crosstab);
        return this.delegateRenderer.render(crosstabResult);
    }

    public static void main(String[] args) {
        LookAndFeelManager.getInstance().init();
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule()});
        AnalysisJobBuilder ajb = (AnalysisJobBuilder)injector.getInstance(AnalysisJobBuilder.class);
        Datastore ds = ((DatastoreCatalog)injector.getInstance(DatastoreCatalog.class)).getDatastore("orderdb");
        DatastoreConnection con = ds.openConnection();
        Table table = con.getSchemaNavigator().convertToTable("PUBLIC.CUSTOMERS");
        ajb.setDatastore(ds);
        ajb.addSourceColumns(table.getLiteralColumns());
        ((AnalyzerJobBuilder)ajb.addAnalyzer(PatternFinderAnalyzer.class).addInputColumns((Collection)ajb.getSourceColumns())).setName("Ungrouped pattern finders");
        AnalyzerJobBuilder groupedPatternFinder = (AnalyzerJobBuilder)ajb.addAnalyzer(PatternFinderAnalyzer.class).setName("Grouped PF");
        ajb.addSourceColumns(new String[]{"PUBLIC.OFFICES.CITY", "PUBLIC.OFFICES.TERRITORY"});
        groupedPatternFinder.addInputColumn(ajb.getSourceColumnByName("PUBLIC.OFFICES.CITY"));
        groupedPatternFinder.addInputColumn(ajb.getSourceColumnByName("PUBLIC.OFFICES.TERRITORY"), ((AnalyzerBeanDescriptor)groupedPatternFinder.getDescriptor()).getConfiguredProperty("Group column"));
        ResultWindow resultWindow = (ResultWindow)injector.getInstance(ResultWindow.class);
        resultWindow.setVisible(true);
        resultWindow.startAnalysis();
    }
}

