/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eobjects.analyzer.beans.api.RendererPrecedence;
import org.eobjects.analyzer.reference.SimpleStringPattern;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.result.CrosstabResult;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.ChartUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.result.AbstractCrosstabResultSwingRenderer;
import org.eobjects.datacleaner.widgets.result.DisplayChartCallback;
import org.eobjects.datacleaner.widgets.table.CrosstabPanel;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

class PatternFinderResultSwingRendererCrosstabDelegate
extends AbstractCrosstabResultSwingRenderer<CrosstabResult> {
    private final MutableReferenceDataCatalog _catalog;

    public PatternFinderResultSwingRendererCrosstabDelegate(WindowContext windowContext, RendererFactory rendererFactory, MutableReferenceDataCatalog referenceDataCatalog) {
        super(windowContext, rendererFactory);
        this._catalog = referenceDataCatalog;
    }

    public RendererPrecedence getPrecedence(CrosstabResult renderable) {
        throw new UnsupportedOperationException("This renderer is programmatically invoked, don't register it in the descriptor catalog.");
    }

    @Override
    public JComponent render(CrosstabResult result) {
        final CrosstabPanel crosstabPanel = super.renderInternal(result);
        final DCTable table = crosstabPanel.getTable();
        if (this.isInitiallyCharted(table) || this.isTooLimitedToChart(table)) {
            return crosstabPanel;
        }
        final DCPanel headerPanel = new DCPanel();
        headerPanel.setLayout(new FlowLayout(Alignment.RIGHT.getFlowLayoutAlignment(), 1, 1));
        JButton chartButton = new JButton("Show distribution chart", ImageManager.getInstance().getImageIcon("images/chart-types/bar.png", new ClassLoader[0]));
        chartButton.setMargin(new Insets(1, 1, 1, 1));
        chartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                headerPanel.setVisible(false);
                PatternFinderResultSwingRendererCrosstabDelegate.this.displayChart(table, crosstabPanel.getDisplayChartCallback());
            }
        });
        headerPanel.add(chartButton);
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)headerPanel, "North");
        panel.add((Component)crosstabPanel, "Center");
        return panel;
    }

    protected void displayChart(DCTable table, DisplayChartCallback displayChartCallback) {
        int rowCount = table.getRowCount();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < rowCount; ++i) {
            Object expressionObject = table.getValueAt(i, 0);
            String expression = this.extractString(expressionObject);
            Object countObject = table.getValueAt(i, 1);
            String countString = this.extractString(countObject);
            int count = Integer.parseInt(countString);
            dataset.addValue((double)count, (Comparable)((Object)expression), (Comparable)((Object)""));
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)"", (String)"Match count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        ChartUtils.applyStyles(chart);
        displayChartCallback.displayChart((JComponent)new ChartPanel(chart));
    }

    @Override
    protected void decorate(CrosstabResult result, DCTable table, DisplayChartCallback displayChartCallback) {
        super.decorate(result, table, displayChartCallback);
        table.setAlignment(1, Alignment.RIGHT);
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object expressionObject = table.getValueAt(i, 0);
            String label = this.extractString(expressionObject);
            final String expression = this.extractExpression(label);
            final String stringPatternName = "PF: " + label;
            if (this._catalog.containsStringPattern(stringPatternName)) continue;
            DCPanel panel = new DCPanel();
            panel.setLayout(new FlowLayout(0, 0, 0));
            panel.add(Box.createHorizontalStrut(4));
            panel.add(new JLabel(label));
            final JButton button = WidgetFactory.createSmallButton("images/actions/save.png");
            button.setToolTipText("Save as string pattern");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PatternFinderResultSwingRendererCrosstabDelegate.this._catalog.addStringPattern((StringPattern)new SimpleStringPattern(stringPatternName, expression));
                    button.setEnabled(false);
                }
            });
            panel.add(Box.createHorizontalStrut(4));
            panel.add(button);
            table.setValueAt(panel, i, 0);
        }
        if (this.isInitiallyCharted(table)) {
            this.displayChart(table, displayChartCallback);
        }
    }

    private String extractExpression(String string) {
        if ("<blank>".equals(string)) {
            return "";
        }
        return string;
    }

    private boolean isInitiallyCharted(DCTable table) {
        return table.getRowCount() >= 8;
    }

    private boolean isTooLimitedToChart(DCTable table) {
        return table.getRowCount() <= 1;
    }

    private String extractString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof JPanel) {
            Component[] components;
            for (Component component : components = ((JPanel)obj).getComponents()) {
                if (!(component instanceof JLabel)) continue;
                return this.extractString(component);
            }
            return null;
        }
        if (obj instanceof JLabel) {
            return ((JLabel)obj).getText();
        }
        return obj.toString();
    }
}

