/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eobjects.analyzer.beans.valuedist.ValueCount;
import org.eobjects.metamodel.util.BaseObject;

public class PieSliceGroup
extends BaseObject
implements Iterable<ValueCount> {
    private final String _name;
    private final int _totalSize;
    private final Collection<String> _values;
    private final int _fixedValueCount;
    private final List<ValueCount> _valueCounts;

    public PieSliceGroup(String name, Collection<String> values, int fixedValueCount) {
        this(name, -1, values, fixedValueCount);
    }

    public PieSliceGroup(String name, int totalSize, Collection<String> values, int fixedValueCount) {
        this._name = name;
        this._totalSize = totalSize;
        this._values = values;
        this._fixedValueCount = fixedValueCount;
        this._valueCounts = null;
    }

    public PieSliceGroup(String name, List<ValueCount> valueCounts) {
        this._name = name;
        this._totalSize = -1;
        this._values = null;
        this._fixedValueCount = -1;
        this._valueCounts = valueCounts;
    }

    public String getName() {
        return this._name;
    }

    public int size() {
        if (this._valueCounts == null) {
            return this._values.size();
        }
        return this._valueCounts.size();
    }

    public Iterator<ValueCount> getValueCounts() {
        if (this._valueCounts == null) {
            final Iterator<String> it = this._values.iterator();
            return new Iterator<ValueCount>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public ValueCount next() {
                    String value = (String)it.next();
                    return new ValueCount(value, PieSliceGroup.this._fixedValueCount);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this._valueCounts.iterator();
    }

    public int getTotalCount() {
        if (this._totalSize != -1) {
            return this._totalSize;
        }
        if (this._valueCounts != null) {
            int result = 0;
            for (ValueCount vc : this._valueCounts) {
                result += vc.getCount();
            }
            return result;
        }
        return this._values.size() * this._fixedValueCount;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
    }

    public void addValueCount(ValueCount vc) {
        if (this._valueCounts == null) {
            assert (vc.getCount() == this._fixedValueCount);
            this._values.add(vc.getValue());
        } else {
            this._valueCounts.add(vc);
        }
    }

    @Override
    public Iterator<ValueCount> iterator() {
        return this.getValueCounts();
    }
}

