/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.result.AnnotatedRowsResult;
import org.eobjects.analyzer.result.SimilarityGroup;
import org.eobjects.analyzer.result.SimilarityResult;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.result.AnnotatedRowsResultSwingRenderer;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;

@RendererBean(value=SwingRenderingFormat.class)
public class SimilarityResultSwingRenderer
extends AbstractRenderer<SimilarityResult, JComponent> {
    public JComponent render(SimilarityResult result) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        final DefaultTreeRenderer rendererDelegate = new DefaultTreeRenderer();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Similarity groups");
        List similarityGroups = result.getSimilarityGroups();
        for (SimilarityGroup sg : similarityGroups) {
            rootNode.add(new DefaultMutableTreeNode(sg));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        final JXTree tree = new JXTree();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject;
                if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof SimilarityGroup) {
                    SimilarityGroup similarityGroup = (SimilarityGroup)userObject;
                    String[] values = similarityGroup.getValues();
                    StringBuilder sb = new StringBuilder();
                    sb.append(values.length);
                    sb.append(": [");
                    for (int i = 0; i < values.length; ++i) {
                        if (i != 0) {
                            sb.append(',');
                        }
                        sb.append('\"');
                        sb.append(values[i]);
                        sb.append('\"');
                        if (sb.length() <= 17) continue;
                        sb.delete(17, sb.length());
                        sb.append(",...");
                        break;
                    }
                    sb.append(']');
                    value = sb.toString();
                }
                return rendererDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        });
        tree.setModel((TreeModel)treeModel);
        final DCPanel centerPanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_LESS_BRIGHT);
        centerPanel.setBorder(WidgetUtils.BORDER_EMPTY);
        centerPanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(WidgetUtils.scrolleable((JComponent)tree));
        splitPane.add(WidgetUtils.scrolleable(centerPanel));
        splitPane.setDividerLocation(180);
        panel.add((Component)splitPane, "Center");
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof SimilarityGroup) {
                    SimilarityGroup similarValues = (SimilarityGroup)userObject;
                    AnnotatedRowsResult annotatedRowsResult = similarValues.getAnnotatedRows();
                    AnnotatedRowsResultSwingRenderer renderer = new AnnotatedRowsResultSwingRenderer();
                    AnnotatedRowsResultSwingRenderer.AnnotatedRowResultPanel comp = renderer.render(annotatedRowsResult);
                    centerPanel.removeAll();
                    centerPanel.add((Component)comp, "North");
                    centerPanel.updateUI();
                }
            }
        });
        return panel;
    }
}

