/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.beans.api.Provided;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.valuedist.ValueCount;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionAnalyzer;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionGroupResult;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionResult;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.SchemaNavigator;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.widgets.DCCollapsiblePanel;
import org.eobjects.datacleaner.widgets.result.ValueDistributionResultSwingRendererGroupDelegate;
import org.eobjects.datacleaner.windows.ResultWindow;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.jdesktop.swingx.VerticalLayout;

@RendererBean(value=SwingRenderingFormat.class)
public class ValueDistributionResultSwingRenderer
extends AbstractRenderer<ValueDistributionResult, JComponent> {
    @Inject
    @Provided
    RendererFactory _rendererFactory;
    @Inject
    @Provided
    WindowContext _windowContext;

    public JComponent render(ValueDistributionResult result) {
        if (result.isGroupingEnabled()) {
            return this.renderGroupedResult(result);
        }
        ValueDistributionResultSwingRendererGroupDelegate delegate = new ValueDistributionResultSwingRendererGroupDelegate(result.getColumnName(), this._rendererFactory, this._windowContext);
        return delegate.renderGroupResult(result.getSingleValueDistributionResult());
    }

    public JComponent renderGroupedResult(ValueDistributionResult result) {
        DCPanel panel = new DCPanel();
        panel.setLayout((LayoutManager)new VerticalLayout(0));
        Set results = result.getGroupedValueDistributionResults();
        for (final ValueDistributionGroupResult res : results) {
            DCCollapsiblePanel collapsiblePanel;
            if (panel.getComponentCount() != 0) {
                panel.add(Box.createVerticalStrut(10));
            }
            LazyRef<JComponent> componentRef = new LazyRef<JComponent>(){

                protected JComponent fetch() {
                    ValueDistributionResultSwingRendererGroupDelegate delegate = new ValueDistributionResultSwingRendererGroupDelegate(res.getGroupName(), ValueDistributionResultSwingRenderer.this._rendererFactory, ValueDistributionResultSwingRenderer.this._windowContext);
                    JSplitPane renderedResult = delegate.renderGroupResult(res);
                    DCPanel decoratedPanel = ValueDistributionResultSwingRenderer.this.createDecoration(renderedResult);
                    return decoratedPanel;
                }
            };
            String label = "Value distribution for group '" + LabelUtils.getLabel((String)res.getGroupName()) + "'";
            ValueCount distinctValue = this.getDistinctValueCount(res);
            if (distinctValue == null) {
                collapsiblePanel = new DCCollapsiblePanel(label, label, false, (Ref<? extends JComponent>)componentRef);
            } else {
                String collapsedLabel = label + ": " + LabelUtils.getLabel((String)distinctValue.getValue()) + "=" + distinctValue.getCount() + "";
                collapsiblePanel = new DCCollapsiblePanel(collapsedLabel, label, true, (Ref<? extends JComponent>)componentRef);
            }
            panel.add(collapsiblePanel.toPanel());
        }
        return panel;
    }

    private ValueCount getDistinctValueCount(ValueDistributionGroupResult res) {
        int uniqueCount;
        int distinctValueCounter = 0;
        ValueCount valueCount = null;
        if (res.getNullCount() > 0) {
            ++distinctValueCounter;
            valueCount = new ValueCount("<null>", res.getNullCount());
        }
        if ((uniqueCount = res.getUniqueCount()) > 0) {
            if (uniqueCount > 1) {
                return null;
            }
            ++distinctValueCounter;
            Collection uniqueValues = res.getUniqueValues();
            String label = "<unique>";
            if (!uniqueValues.isEmpty()) {
                label = (String)uniqueValues.iterator().next();
            }
            valueCount = new ValueCount(label, 1);
        }
        if (distinctValueCounter > 1) {
            return null;
        }
        if (res.getTopValues().getActualSize() > 0) {
            distinctValueCounter += res.getTopValues().getActualSize();
            valueCount = (ValueCount)res.getTopValues().getValueCounts().get(0);
        }
        if (res.getBottomValues().getActualSize() > 0) {
            distinctValueCounter += res.getBottomValues().getActualSize();
            valueCount = (ValueCount)res.getBottomValues().getValueCounts().get(0);
        }
        if (distinctValueCounter > 1) {
            return null;
        }
        return valueCount;
    }

    private DCPanel createDecoration(JComponent renderedResult) {
        DCPanel wrappingPanel = new DCPanel();
        wrappingPanel.setLayout(new BorderLayout());
        wrappingPanel.add((Component)renderedResult, "Center");
        wrappingPanel.setBorder(new EmptyBorder(4, 20, 4, 4));
        return wrappingPanel;
    }

    public static void main(String[] args) {
        LookAndFeelManager.getInstance().init();
        Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule()});
        AnalysisJobBuilder ajb = (AnalysisJobBuilder)injector.getInstance(AnalysisJobBuilder.class);
        Datastore ds = ((DatastoreCatalog)injector.getInstance(DatastoreCatalog.class)).getDatastore("orderdb");
        DatastoreConnection con = ds.openConnection();
        SchemaNavigator sn = con.getSchemaNavigator();
        ajb.setDatastore(ds);
        ajb.addSourceColumns(sn.convertToTable("PUBLIC.TRIAL_BALANCE").getColumns());
        ajb.addAnalyzer(ValueDistributionAnalyzer.class).addInputColumns((Collection)ajb.getSourceColumns());
        ajb.addSourceColumns(sn.convertToTable("PUBLIC.CUSTOMERS").getColumns());
        AnalyzerJobBuilder groupedValueDist = ajb.addAnalyzer(ValueDistributionAnalyzer.class);
        groupedValueDist.addInputColumn(ajb.getSourceColumnByName("PUBLIC.CUSTOMERS.CITY"));
        groupedValueDist.setConfiguredProperty("Group column", (Object)ajb.getSourceColumnByName("PUBLIC.CUSTOMERS.COUNTRY"));
        ResultWindow resultWindow = (ResultWindow)injector.getInstance(ResultWindow.class);
        resultWindow.setVisible(true);
        resultWindow.startAnalysis();
    }
}

