/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eobjects.analyzer.beans.valuedist.ValueCount;
import org.eobjects.analyzer.beans.valuedist.ValueDistributionGroupResult;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.result.renderer.RendererFactory;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ChartUtils;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.result.AbstractCrosstabResultSwingRenderer;
import org.eobjects.datacleaner.widgets.result.DCDrawingSupplier;
import org.eobjects.datacleaner.widgets.result.PieSliceGroup;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.DetailsResultWindow;
import org.jdesktop.swingx.VerticalLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.ShortTextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ValueDistributionResultSwingRendererGroupDelegate {
    private static final Logger logger = LoggerFactory.getLogger(ValueDistributionResultSwingRendererGroupDelegate.class);
    private static final Color[] SLICE_COLORS = DCDrawingSupplier.DEFAULT_FILL_COLORS;
    private static final int DEFAULT_PREFERRED_SLICES = 32;
    private static final int DEFAULT_MAX_SLICES = 40;
    private final Map<String, Color> _valueColorMap;
    private final Map<String, PieSliceGroup> _groups = new HashMap<String, PieSliceGroup>();
    private final DefaultPieDataset _dataset = new DefaultPieDataset();
    private final JButton _backButton = WidgetFactory.createButton("Back", "images/actions/back.png");
    private final int _preferredSlices;
    private final int _maxSlices;
    private final String _groupOrColumnName;
    private final DCTable _table;
    private final RendererFactory _rendererFactory;
    private final WindowContext _windowContext;

    public ValueDistributionResultSwingRendererGroupDelegate(String groupOrColumnName, RendererFactory rendererFactory, WindowContext windowContext) {
        this(groupOrColumnName, 32, 40, rendererFactory, windowContext);
    }

    public ValueDistributionResultSwingRendererGroupDelegate(String groupOrColumnName, int preferredSlices, int maxSlices, RendererFactory rendererFactory, WindowContext windowContext) {
        this._groupOrColumnName = groupOrColumnName;
        this._preferredSlices = preferredSlices;
        this._maxSlices = maxSlices;
        this._rendererFactory = rendererFactory;
        this._windowContext = windowContext;
        this._table = new DCTable("Value", "COUNT(*)");
        this._table.setRowHeight(22);
        this._valueColorMap = new HashMap<String, Color>();
        this._valueColorMap.put("<blank>".toUpperCase(), WidgetUtils.BG_COLOR_BRIGHTEST);
        this._valueColorMap.put("<unique>".toUpperCase(), WidgetUtils.BG_COLOR_BRIGHT);
        this._valueColorMap.put("<null>".toUpperCase(), WidgetUtils.BG_COLOR_DARKEST);
        this._valueColorMap.put("RED", WidgetUtils.ADDITIONAL_COLOR_RED_BRIGHT);
        this._valueColorMap.put("ORANGE", WidgetUtils.BG_COLOR_ORANGE_BRIGHT);
        this._valueColorMap.put("GREEN", WidgetUtils.ADDITIONAL_COLOR_GREEN_BRIGHT);
        this._valueColorMap.put("PURPLE", WidgetUtils.ADDITIONAL_COLOR_PURPLE_BRIGHT);
        this._valueColorMap.put("CYAN", WidgetUtils.ADDITIONAL_COLOR_CYAN_BRIGHT);
        this._valueColorMap.put("BLUE", WidgetUtils.BG_COLOR_BLUE_BRIGHT);
        this._valueColorMap.put("NOT_PROCESSED", WidgetUtils.BG_COLOR_LESS_DARK);
    }

    public JSplitPane renderGroupResult(final ValueDistributionGroupResult result) {
        PieSliceGroup singleGroup;
        boolean userSpecifiedGroups;
        int uniqueCount = result.getUniqueCount();
        int distinctCount = result.getDistinctCount();
        int totalCount = result.getTotalCount();
        Collection uniqueValues = result.getUniqueValues();
        if (uniqueValues != null && !uniqueValues.isEmpty()) {
            PieSliceGroup pieSliceGroup = new PieSliceGroup("<unique>", uniqueCount, uniqueValues, 1);
            this._groups.put(pieSliceGroup.getName(), pieSliceGroup);
        } else if (uniqueCount > 0) {
            this._dataset.setValue((Comparable)((Object)"<unique>"), (double)uniqueCount);
        }
        int nullCount = result.getNullCount();
        if (nullCount > 0) {
            this._dataset.setValue((Comparable)((Object)"<null>"), (double)nullCount);
        }
        List topValueCounts = result.getTopValues().getValueCounts();
        List bottomValueCounts = result.getBottomValues().getValueCounts();
        boolean bl = userSpecifiedGroups = !topValueCounts.isEmpty() && !bottomValueCounts.isEmpty();
        if (userSpecifiedGroups || topValueCounts.size() + bottomValueCounts.size() < this._preferredSlices) {
            for (ValueCount valueCount : topValueCounts) {
                this._dataset.setValue((Comparable)((Object)LabelUtils.getLabel((String)valueCount.getValue())), (double)valueCount.getCount());
            }
            for (ValueCount valueCount : bottomValueCounts) {
                this._dataset.setValue((Comparable)((Object)LabelUtils.getLabel((String)valueCount.getValue())), (double)valueCount.getCount());
            }
        } else {
            List valueCounts = topValueCounts;
            if (!bottomValueCounts.isEmpty()) {
                valueCounts = bottomValueCounts;
            }
            this.createGroups(valueCounts);
            for (ValueCount valueCount : valueCounts) {
                this._dataset.setValue((Comparable)((Object)LabelUtils.getLabel((String)valueCount.getValue())), (double)valueCount.getCount());
            }
        }
        boolean singleGroupExploded = false;
        if (this._groups.size() == 1 && (singleGroup = this._groups.values().iterator().next()).size() + this._dataset.getItemCount() <= this._preferredSlices) {
            singleGroupExploded = true;
            for (ValueCount vc : singleGroup) {
                this._dataset.setValue((Comparable)((Object)LabelUtils.getLabel((String)vc.getValue())), (double)vc.getCount());
            }
            this._dataset.sortByValues(SortOrder.DESCENDING);
        }
        if (!singleGroupExploded) {
            for (PieSliceGroup group : this._groups.values()) {
                this._dataset.setValue((Comparable)((Object)group.getName()), (double)group.getTotalCount());
            }
        }
        logger.info("Rendering with {} slices", (Object)this._dataset.getItemCount());
        this.drillToOverview(result);
        JFreeChart chart = ChartFactory.createPieChart((String)("Value distribution of " + this._groupOrColumnName), (PieDataset)this._dataset, (boolean)false, (boolean)true, (boolean)false);
        ShortTextTitle totalCountSubtitle = new ShortTextTitle("Total count: " + totalCount);
        ShortTextTitle distinctCountSubtitle = new ShortTextTitle("Distinct count: " + distinctCount);
        chart.setSubtitles(Arrays.asList(totalCountSubtitle, distinctCountSubtitle));
        ChartUtils.applyStyles(chart);
        PiePlot plot = (PiePlot)chart.getPlot();
        int colorIndex = 0;
        for (int i = 0; i < this._dataset.getItemCount(); ++i) {
            Color color;
            String key = (String)((Object)this._dataset.getKey(i));
            String upperCaseKey = key.toUpperCase();
            if (this._valueColorMap.containsKey(upperCaseKey)) {
                color = this._valueColorMap.get(upperCaseKey);
            } else {
                if (i == this._dataset.getItemCount() - 1 && colorIndex == 0) {
                    ++colorIndex;
                }
                Color colorCandidate = SLICE_COLORS[colorIndex];
                int darkAmount = i / SLICE_COLORS.length;
                for (int j = 0; j < darkAmount; ++j) {
                    colorCandidate = WidgetUtils.slightlyDarker(colorCandidate);
                }
                color = colorCandidate;
                if (++colorIndex >= SLICE_COLORS.length) {
                    colorIndex = 0;
                }
            }
            plot.setSectionPaint((Comparable)((Object)key), (Paint)color);
        }
        plot.setSectionPaint((Comparable)((Object)"<unique>"), (Paint)WidgetUtils.BG_COLOR_BRIGHT);
        plot.setSectionPaint((Comparable)((Object)"<null>"), (Paint)WidgetUtils.BG_COLOR_DARKEST);
        final ChartPanel chartPanel = new ChartPanel(chart);
        int chartHeight = 450;
        if (this._dataset.getItemCount() > 32) {
            chartHeight += 200;
        } else if (this._dataset.getItemCount() > 25) {
            chartHeight += 100;
        }
        chartPanel.setPreferredSize(new Dimension(0, chartHeight));
        chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseMoved(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof PieSectionEntity) {
                    PieSectionEntity pieSectionEntity = (PieSectionEntity)entity;
                    String sectionKey = (String)((Object)pieSectionEntity.getSectionKey());
                    if (ValueDistributionResultSwingRendererGroupDelegate.this._groups.containsKey(sectionKey)) {
                        chartPanel.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        chartPanel.setCursor(Cursor.getDefaultCursor());
                    }
                } else {
                    chartPanel.setCursor(Cursor.getDefaultCursor());
                }
            }

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof PieSectionEntity) {
                    PieSectionEntity pieSectionEntity = (PieSectionEntity)entity;
                    String sectionKey = (String)((Object)pieSectionEntity.getSectionKey());
                    if (ValueDistributionResultSwingRendererGroupDelegate.this._groups.containsKey(sectionKey)) {
                        ValueDistributionResultSwingRendererGroupDelegate.this.drillToGroup(result, sectionKey, true);
                    }
                }
            }
        });
        DCPanel leftPanel = new DCPanel();
        leftPanel.setLayout((LayoutManager)new VerticalLayout());
        leftPanel.add(WidgetUtils.decorateWithShadow((JComponent)chartPanel, true, 4));
        this._backButton.setMargin(new Insets(0, 0, 0, 0));
        this._backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueDistributionResultSwingRendererGroupDelegate.this.drillToOverview(result);
            }
        });
        DCPanel rightPanel = new DCPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add((Component)this._backButton, "North");
        rightPanel.add((Component)this._table.toPanel(), "Center");
        rightPanel.getSize().height = chartHeight;
        JSplitPane split = new JSplitPane(1);
        split.setOpaque(false);
        split.add(leftPanel);
        split.add(rightPanel);
        split.setDividerLocation(550);
        return split;
    }

    public Map<String, PieSliceGroup> getGroups() {
        return this._groups;
    }

    public DefaultPieDataset getDataset() {
        return this._dataset;
    }

    private void drillToOverview(final ValueDistributionGroupResult result) {
        DefaultTableModel model = new DefaultTableModel(new String[]{"Value", "COUNT(*)"}, this._dataset.getItemCount());
        for (int i = 0; i < this._dataset.getItemCount(); ++i) {
            final String key = (String)((Object)this._dataset.getKey(i));
            int count = this._dataset.getValue(i).intValue();
            model.setValueAt(key, i, 0);
            if (this._groups.containsKey(key)) {
                DCPanel panel = new DCPanel();
                panel.setLayout(new FlowLayout(0, 0, 0));
                JLabel label = new JLabel(count + "");
                JButton button = WidgetFactory.createSmallButton("images/actions/drill-to-detail.png");
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ValueDistributionResultSwingRendererGroupDelegate.this.drillToGroup(result, key, true);
                    }
                });
                panel.add(label);
                panel.add(Box.createHorizontalStrut(4));
                panel.add(button);
                model.setValueAt(panel, i, 1);
                continue;
            }
            this.setCountValue(result, model, i, new ValueCount(key, count));
        }
        this._table.setModel(model);
        this._backButton.setVisible(false);
    }

    private void setCountValue(final ValueDistributionGroupResult result, TableModel model, int i, final ValueCount vc) {
        if (result.isAnnotationsEnabled() && result.hasAnnotation(vc.getValue())) {
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent action) {
                    String title = "Detailed results for [" + vc.getValue() + "]";
                    ArrayList<AnalyzerResult> results = new ArrayList<AnalyzerResult>();
                    results.add((AnalyzerResult)result.getAnnotatedRows(vc.getValue()));
                    DetailsResultWindow window = new DetailsResultWindow(title, results, ValueDistributionResultSwingRendererGroupDelegate.this._windowContext, ValueDistributionResultSwingRendererGroupDelegate.this._rendererFactory);
                    window.setVisible(true);
                }
            };
            DCPanel panel = AbstractCrosstabResultSwingRenderer.createActionableValuePanel(vc.getCount(), Alignment.LEFT, action, "images/actions/drill-to-detail.png");
            model.setValueAt(panel, i, 1);
        } else {
            model.setValueAt(vc.getCount(), i, 1);
        }
    }

    private void drillToGroup(ValueDistributionGroupResult result, String groupName, boolean showBackButton) {
        PieSliceGroup group = this._groups.get(groupName);
        DefaultTableModel model = new DefaultTableModel(new String[]{groupName + " value", "COUNT(*)"}, group.size());
        Iterator<ValueCount> valueCounts = group.getValueCounts();
        int i = 0;
        while (valueCounts.hasNext()) {
            ValueCount vc = valueCounts.next();
            model.setValueAt(LabelUtils.getLabel((String)vc.getValue()), i, 0);
            this.setCountValue(result, model, i, vc);
            ++i;
        }
        this._table.setModel(model);
        this._backButton.setVisible(showBackButton);
    }

    protected void createGroups(List<ValueCount> valueCounts) {
        HashSet<Integer> skipCounts = new HashSet<Integer>();
        int previousGroupFrequency = 1;
        int datasetItemCount = this._dataset.getItemCount();
        while (datasetItemCount + this._groups.size() < this._preferredSlices && skipCounts.size() != valueCounts.size()) {
            int groupFrequency = -1;
            for (ValueCount vc : valueCounts) {
                int count = vc.getCount();
                if (groupFrequency == -1) {
                    groupFrequency = count;
                } else if (!skipCounts.contains(count)) {
                    groupFrequency = Math.min(groupFrequency, count);
                }
                if (groupFrequency != previousGroupFrequency + 1) continue;
                break;
            }
            if (groupFrequency < previousGroupFrequency) break;
            String groupName = "<count=" + groupFrequency + ">";
            ArrayList<ValueCount> groupContent = new ArrayList<ValueCount>();
            logger.debug("Lowest repeated frequency above {} found: {}. Fetching from {} ungrouped values", new Object[]{previousGroupFrequency, groupFrequency, valueCounts.size()});
            Iterator<ValueCount> it = valueCounts.iterator();
            while (it.hasNext()) {
                ValueCount vc = it.next();
                int count = vc.getCount();
                if (groupFrequency != count) continue;
                groupContent.add(vc);
                it.remove();
            }
            if (groupContent.size() == 1) {
                logger.debug("Skipping this group because it has only one occurrence");
                skipCounts.add(groupFrequency);
                valueCounts.add((ValueCount)groupContent.get(0));
            } else {
                logger.info("Grouping {} values to group: {}", (Object)groupContent.size(), (Object)groupName);
                ArrayList<String> groupContentValues = new ArrayList<String>(groupContent.size());
                for (ValueCount valueCount : groupContent) {
                    groupContentValues.add(valueCount.getValue());
                }
                PieSliceGroup group = new PieSliceGroup(groupName, groupContentValues, groupFrequency);
                this._groups.put(groupName, group);
            }
            previousGroupFrequency = groupFrequency;
        }
        if (datasetItemCount + this._groups.size() + valueCounts.size() > this._maxSlices) {
            int aggregatedGroupCount = this._maxSlices - this._groups.size();
            logger.info("Amount of groups outgrowed the preferred count, creating {} aggregated groups", (Object)aggregatedGroupCount);
            int aggregatedGroupSize = valueCounts.size() / aggregatedGroupCount;
            logger.info("Creating {} range groups", (Object)aggregatedGroupCount);
            for (int i = 0; i < aggregatedGroupCount; ++i) {
                LinkedList<ValueCount> groupContent = new LinkedList<ValueCount>();
                while (groupContent.size() < aggregatedGroupSize && !valueCounts.isEmpty()) {
                    int minFrequency = -1;
                    for (ValueCount vc : valueCounts) {
                        int count = vc.getCount();
                        if (minFrequency == -1) {
                            minFrequency = count;
                            continue;
                        }
                        minFrequency = Math.min(count, minFrequency);
                    }
                    logger.debug("Adding values with count={} to range group {}.", (Object)minFrequency, (Object)(i + 1));
                    Iterator<ValueCount> it = valueCounts.iterator();
                    while (it.hasNext()) {
                        ValueCount vc;
                        vc = it.next();
                        if (vc.getCount() != minFrequency) continue;
                        groupContent.add(vc);
                        it.remove();
                    }
                }
                if (groupContent.isEmpty()) break;
                String groupName = "<count=[" + ((ValueCount)groupContent.getFirst()).getCount() + "-" + ((ValueCount)groupContent.getLast()).getCount() + "]>";
                PieSliceGroup group = new PieSliceGroup(groupName, groupContent);
                this._groups.put(groupName, group);
            }
        }
    }
}

