/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.result;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.eobjects.analyzer.beans.api.RendererBean;
import org.eobjects.analyzer.beans.writers.WriteDataResult;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreConnection;
import org.eobjects.analyzer.connection.FileDatastore;
import org.eobjects.analyzer.result.renderer.AbstractRenderer;
import org.eobjects.analyzer.result.renderer.SwingRenderingFormat;
import org.eobjects.datacleaner.actions.PreviewSourceDataActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.guice.DCModule;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableDatastoreCatalog;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RendererBean(value=SwingRenderingFormat.class)
public class WriteDataResultSwingRenderer
extends AbstractRenderer<WriteDataResult, JComponent> {
    private static final Logger logger = LoggerFactory.getLogger(WriteDataResultSwingRenderer.class);
    private final ImageManager imageManager = ImageManager.getInstance();
    @Inject
    WindowContext windowContext;
    @Inject
    DCModule _parentModule;
    @Inject
    MutableDatastoreCatalog _datastoreCatalog;

    public JComponent render(WriteDataResult result) {
        JLabel label;
        EmptyBorder border = new EmptyBorder(10, 10, 10, 10);
        DCPanel panel = new DCPanel();
        panel.setBorder(border);
        panel.setLayout((LayoutManager)new VerticalLayout(4));
        int insertCount = result.getWrittenRowCount();
        int updateCount = result.getUpdatesCount();
        if (insertCount == 0 && updateCount == 0) {
            label = new JLabel("No rows written!", this.imageManager.getImageIcon("images/status/warning.png", new ClassLoader[0]), 2);
            panel.add(label);
        } else {
            if (insertCount != 0) {
                label = new JLabel(insertCount + " inserts executed!", this.imageManager.getImageIcon("images/status/valid.png", new ClassLoader[0]), 2);
                panel.add(label);
            }
            if (updateCount != 0) {
                label = new JLabel(updateCount + " updates executed!", this.imageManager.getImageIcon("images/status/valid.png", new ClassLoader[0]), 2);
                panel.add(label);
            }
            DCPanel buttonPanel = this.createButtonPanel(result);
            panel.add(buttonPanel);
        }
        if (result.getErrorRowCount() > 0) {
            DCPanel errorRowsPanel = new DCPanel();
            errorRowsPanel.setLayout(new BorderLayout());
            JLabel icon = new JLabel(this.imageManager.getImageIcon("images/status/error.png", new ClassLoader[0]));
            errorRowsPanel.add((Component)icon, "West");
            final FileDatastore errorDatastore = result.getErrorDatastore();
            final JXEditorPane editorPane = new JXEditorPane("text/html", "<b>" + result.getErrorRowCount() + " records</b> could <i>not</i> be written to the table!<br/>" + "The records were written to <a href=\"http://datacleaner.org/preview_datastore\">" + errorDatastore.getFilename() + "</a> (<a href=\"http://datacleaner.org/register_datastore\">Register as datastore</a>).");
            editorPane.setEditable(false);
            editorPane.setOpaque(false);
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                        String href = e.getDescription();
                        if ("http://datacleaner.org/register_datastore".equals(href)) {
                            WriteDataResultSwingRenderer.this._datastoreCatalog.addDatastore((Datastore)errorDatastore);
                            JOptionPane.showMessageDialog((Component)editorPane, "Saved datastore: " + errorDatastore.getName());
                        } else if ("http://datacleaner.org/preview_datastore".equals(href)) {
                            DatastoreConnection errorCon = errorDatastore.openConnection();
                            try {
                                Table table = errorCon.getDataContext().getDefaultSchema().getTables()[0];
                                PreviewSourceDataActionListener actionListener = new PreviewSourceDataActionListener(WriteDataResultSwingRenderer.this.windowContext, (Datastore)errorDatastore, table);
                                actionListener.actionPerformed(null);
                            }
                            finally {
                                errorCon.close();
                            }
                        } else {
                            logger.error("Unexpected href: " + href + ". Event was: " + e);
                        }
                    }
                }
            });
            errorRowsPanel.add((Component)editorPane, "Center");
            panel.add(errorRowsPanel);
        }
        return panel;
    }

    private DCPanel createButtonPanel(final WriteDataResult result) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new FlowLayout(Alignment.LEFT.getFlowLayoutAlignment(), 0, 4));
        final Datastore datastore = result.getDatastore((DatastoreCatalog)this._datastoreCatalog);
        Insets buttonMargin = new Insets(1, 4, 1, 4);
        if (datastore != null && datastore.getName() != null) {
            Datastore ds = this._datastoreCatalog.getDatastore(datastore.getName());
            if (!datastore.equals(ds)) {
                final JButton addDatastoreButton = new JButton("Add to datastores", this.imageManager.getImageIcon("images/actions/add.png", new ClassLoader[0]));
                addDatastoreButton.setMargin(buttonMargin);
                addDatastoreButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WriteDataResultSwingRenderer.this._datastoreCatalog.addDatastore(datastore);
                        addDatastoreButton.setEnabled(false);
                    }
                });
                panel.add(addDatastoreButton);
                panel.add(Box.createHorizontalStrut(4));
            }
            JButton analyzeButton = new JButton("Analyze this datastore", this.imageManager.getImageIcon("images/filetypes/analysis_job.png", new ClassLoader[0]));
            analyzeButton.setMargin(buttonMargin);
            analyzeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Injector injector = Guice.createInjector((Module[])new Module[]{new DCModule(WriteDataResultSwingRenderer.this._parentModule, null)});
                    AnalysisJobBuilderWindow window = (AnalysisJobBuilderWindow)injector.getInstance(AnalysisJobBuilderWindow.class);
                    window.setDatastore(datastore);
                    window.open();
                }
            });
            panel.add(analyzeButton);
            panel.add(Box.createHorizontalStrut(4));
            JButton previewButton = new JButton("Preview table", this.imageManager.getImageIcon("images/actions/preview_data.png", new ClassLoader[0]));
            previewButton.setMargin(buttonMargin);
            previewButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    DatastoreConnection con = datastore.openConnection();
                    try {
                        con.getSchemaNavigator().refreshSchemas();
                        Table previewTable = result.getPreviewTable(datastore);
                        if (previewTable == null) {
                            throw new IllegalStateException("Result did not return any preview table: " + result);
                        }
                        PreviewSourceDataActionListener actionListener = new PreviewSourceDataActionListener(WriteDataResultSwingRenderer.this.windowContext, datastore, previewTable);
                        actionListener.actionPerformed(null);
                    }
                    finally {
                        con.close();
                    }
                }
            });
            panel.add(previewButton);
        }
        return panel;
    }
}

