/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public final class ColumnHighlighter
implements Highlighter {
    private static final Color BACKGROUND_COLOR = WidgetUtils.BG_COLOR_LESS_DARK;
    private static final Color FOREGROUND_COLOR = WidgetUtils.BG_COLOR_BRIGHTEST;
    private ColorHighlighter _colorHighlighter;
    private HighlightPredicate.ColumnHighlightPredicate _evaluatedColumnsPredicate;

    public ColumnHighlighter(int[] columnIndexes) {
        this._evaluatedColumnsPredicate = new HighlightPredicate.ColumnHighlightPredicate(columnIndexes);
        this._colorHighlighter = new ColorHighlighter((HighlightPredicate)this._evaluatedColumnsPredicate, BACKGROUND_COLOR, FOREGROUND_COLOR);
    }

    public ColumnHighlighter(int index) {
        this(new int[]{index});
    }

    public void addChangeListener(ChangeListener arg0) {
        this._colorHighlighter.addChangeListener(arg0);
    }

    public ChangeListener[] getChangeListeners() {
        return this._colorHighlighter.getChangeListeners();
    }

    public Component highlight(Component component, ComponentAdapter adapter) {
        if (this._evaluatedColumnsPredicate.isHighlighted(component, adapter)) {
            Component highlight = this._colorHighlighter.highlight(component, adapter);
            return highlight;
        }
        return component;
    }

    public void removeChangeListener(ChangeListener listener) {
        this._colorHighlighter.removeChangeListener(listener);
    }
}

