/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tabs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eobjects.datacleaner.panels.DCBannerPanel;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPaneUI;
import org.eobjects.datacleaner.widgets.tabs.TabCloseEvent;
import org.eobjects.datacleaner.widgets.tabs.TabCloseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -411551524171347329L;
    private static Logger _logger = LoggerFactory.getLogger(CloseableTabbedPane.class);
    private final List<TabCloseListener> _closeListeners = new LinkedList<TabCloseListener>();
    private final List<Integer> _unclosables = new LinkedList<Integer>();
    private final List<Integer> _separators = new LinkedList<Integer>();
    private final Map<Integer, ActionListener> _doubleClickActionListeners = new HashMap<Integer, ActionListener>();
    private final Map<Integer, ActionListener> _rightClickActionListeners = new HashMap<Integer, ActionListener>();
    private Color unselectedTabTopColor = WidgetUtils.BG_COLOR_DARKEST;
    private Color unselectedTabBottomColor = WidgetUtils.BG_COLOR_DARKEST;
    private Color selectedTabTopColor = WidgetUtils.BG_COLOR_BRIGHTEST;
    private Color selectedTabBottomColor = WidgetUtils.BG_COLOR_BRIGHT;
    private Color _tabBorderColor = WidgetUtils.BG_COLOR_LESS_DARK;

    public CloseableTabbedPane() {
        this(true);
    }

    public CloseableTabbedPane(boolean addBorder) {
        super(1, 0);
        this.setUI(new CloseableTabbedPaneUI(this));
        this.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this.setBackground(WidgetUtils.BG_COLOR_DARK);
        this.setOpaque(true);
        if (addBorder) {
            this.setBorder(WidgetUtils.BORDER_WIDE);
        }
    }

    public CloseableTabbedPane setUnclosableTab(int val) {
        if (!this._unclosables.contains(val)) {
            this._unclosables.add(val);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeparator() {
        CloseableTabbedPane closeableTabbedPane = this;
        synchronized (closeableTabbedPane) {
            int tabCountBefore = this.getTabCount();
            this.addTab("SEPARATOR", new JLabel());
            this._separators.add(tabCountBefore);
        }
    }

    public void setClosableTab(int val) {
        this._unclosables.remove(val);
    }

    public <E extends Component> List<E> getTabsOfClass(Class<E> clazz) {
        Component[] components;
        ArrayList<Component> list = new ArrayList<Component>();
        for (Component component : components = this.getComponents()) {
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getComponent(0);
            }
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            list.add(component);
        }
        return list;
    }

    public void addTabCloseListener(TabCloseListener lis) {
        this._closeListeners.add(lis);
    }

    public void removeTabCloseListener(TabCloseListener lis) {
        this._closeListeners.remove(lis);
    }

    public void closeTab(int tabIndex) {
        Component component = this.getComponent(tabIndex);
        this.remove(tabIndex);
        int selectedIndex = this.getSelectedIndex();
        while (this._separators.contains(selectedIndex) && selectedIndex > 0) {
            this.setSelectedIndex(--selectedIndex);
        }
        if (!this._closeListeners.isEmpty()) {
            TabCloseEvent ev = new TabCloseEvent(this, tabIndex, component);
            for (TabCloseListener l : this._closeListeners) {
                try {
                    l.tabClosed(ev);
                }
                catch (Exception ex) {
                    _logger.error(ex.toString(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void remove(int removedIndex) {
        ActionListener actionListener;
        int curIndex;
        super.remove(removedIndex);
        this._rightClickActionListeners.remove(removedIndex);
        this._doubleClickActionListeners.remove(removedIndex);
        TreeSet keySet = new TreeSet(Collections.reverseOrder());
        keySet.addAll(this._rightClickActionListeners.keySet());
        for (Integer key : keySet) {
            curIndex = key;
            if (curIndex <= removedIndex) continue;
            actionListener = this._rightClickActionListeners.get(curIndex);
            this._rightClickActionListeners.remove(curIndex);
            this._rightClickActionListeners.put(curIndex - 1, actionListener);
        }
        keySet = new TreeSet(Collections.reverseOrder());
        keySet.addAll(this._doubleClickActionListeners.keySet());
        for (Integer key : keySet) {
            curIndex = key;
            if (curIndex <= removedIndex) continue;
            actionListener = this._doubleClickActionListeners.get(curIndex);
            this._doubleClickActionListeners.remove(curIndex);
            this._doubleClickActionListeners.put(curIndex - 1, actionListener);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.getSeparators().contains(index)) {
            this.setSelectedIndex(--index);
        } else {
            super.setSelectedIndex(index);
        }
    }

    public void closeAllTabs() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.closeTab(i);
        }
        this.removeAll();
    }

    protected List<Integer> getUnclosables() {
        return this._unclosables;
    }

    protected List<Integer> getSeparators() {
        return this._separators;
    }

    public void setRightClickActionListener(int index, ActionListener actionListener) {
        this._rightClickActionListeners.put(index, actionListener);
    }

    public ActionListener getRightClickActionListener(int index) {
        return this._rightClickActionListeners.get(index);
    }

    public void setDoubleClickActionListener(int index, ActionListener actionListener) {
        this._doubleClickActionListeners.put(index, actionListener);
    }

    public ActionListener getDoubleClickActionListener(int index) {
        return this._doubleClickActionListeners.get(index);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.closeAllTabs();
    }

    @Override
    public Color getForegroundAt(int index) {
        if (this.getSelectedIndex() == index) {
            return WidgetUtils.BG_COLOR_DARKEST;
        }
        return super.getForegroundAt(index);
    }

    @Override
    public void updateUI() {
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
    }

    public Color getUnselectedTabTopColor() {
        return this.unselectedTabTopColor;
    }

    public void setUnselectedTabTopColor(Color unselectedTabTopColor) {
        this.unselectedTabTopColor = unselectedTabTopColor;
    }

    public Color getUnselectedTabBottomColor() {
        return this.unselectedTabBottomColor;
    }

    public void setUnselectedTabBottomColor(Color unselectedTabBottomColor) {
        this.unselectedTabBottomColor = unselectedTabBottomColor;
    }

    public Color getSelectedTabTopColor() {
        return this.selectedTabTopColor;
    }

    public void setSelectedTabTopColor(Color selectedTabTopColor) {
        this.selectedTabTopColor = selectedTabTopColor;
    }

    public Color getSelectedTabBottomColor() {
        return this.selectedTabBottomColor;
    }

    public void setSelectedTabBottomColor(Color selectedTabBottomColor) {
        this.selectedTabBottomColor = selectedTabBottomColor;
    }

    public Color getTabBorderColor() {
        return this._tabBorderColor;
    }

    public void setTabBorderColor(Color tabBorderColor) {
        this._tabBorderColor = tabBorderColor;
    }

    public Rectangle getTabBounds(int tabIndex) {
        return this.getUI().getTabBounds(this, tabIndex);
    }

    public void bindTabTitleToBanner(final DCBannerPanel bannerPanel) {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedIndex = CloseableTabbedPane.this.getSelectedIndex();
                if (selectedIndex == -1) {
                    return;
                }
                String title = CloseableTabbedPane.this.getTitleAt(selectedIndex);
                bannerPanel.setTitle2(title);
                bannerPanel.updateUI();
            }
        };
        this.addChangeListener(changeListener);
        changeListener.stateChanged(null);
    }
}

