/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets.tabs;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPaneUI;

class CloseableTabbedPaneMouseListener
extends MouseAdapter
implements MouseMotionListener {
    private final CloseableTabbedPaneUI _tabbedPaneUI;
    private final CloseableTabbedPane _pane;
    private volatile int _closedIndex = -1;

    public CloseableTabbedPaneMouseListener(CloseableTabbedPaneUI closeableTabbedPaneUI, CloseableTabbedPane pane) {
        this._tabbedPaneUI = closeableTabbedPaneUI;
        this._pane = pane;
    }

    public int getClosedIndex() {
        return this._closedIndex;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this._closedIndex = -1;
        this._pane.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ActionListener actionListener;
        int button = e.getButton();
        if (button == 0) {
            return;
        }
        if (!this._pane.isEnabled()) {
            return;
        }
        int clickedTabIndex = this._tabbedPaneUI.tabForCoordinate(this._pane, e.getX(), e.getY());
        if (clickedTabIndex == -1) {
            return;
        }
        if (button == 1) {
            ActionListener doubleClickActionListener;
            int selectedIndex = this._pane.getSelectedIndex();
            if (e.getClickCount() > 1 && (doubleClickActionListener = this._pane.getDoubleClickActionListener(selectedIndex)) != null) {
                doubleClickActionListener.actionPerformed(new ActionEvent(e, clickedTabIndex, "double-click"));
                return;
            }
            int runIndexOfSelectedTab = this._tabbedPaneUI.getRunForTab(this._pane.getTabCount(), selectedIndex);
            int runIndexOfClickedTab = this._tabbedPaneUI.getRunForTab(this._pane.getTabCount(), clickedTabIndex);
            if (runIndexOfClickedTab != runIndexOfSelectedTab) {
                return;
            }
            if (this._pane.getUnclosables().contains(clickedTabIndex)) {
                return;
            }
            if (this._pane.getSeparators().contains(clickedTabIndex)) {
                return;
            }
            Rectangle r = this._tabbedPaneUI.closeRectFor(clickedTabIndex);
            if (r.contains(new Point(e.getX(), e.getY()))) {
                this._pane.closeTab(clickedTabIndex);
            }
        }
        if ((button == 2 || button == 3) && (actionListener = this._pane.getRightClickActionListener(clickedTabIndex)) != null) {
            actionListener.actionPerformed(new ActionEvent(e, clickedTabIndex, "right-click"));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this._pane.isEnabled()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        int tabIndex = this._tabbedPaneUI.tabForCoordinate(this._pane, e.getX(), e.getY());
        if (tabIndex == -1) {
            return;
        }
        if (this._pane.getUnclosables().contains(tabIndex)) {
            return;
        }
        if (this._pane.getSeparators().contains(tabIndex)) {
            return;
        }
        Rectangle r = this._tabbedPaneUI.closeRectFor(tabIndex);
        this._closedIndex = r.contains(new Point(e.getX(), e.getY())) ? tabIndex : -1;
        this._pane.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
        this.mousePressed(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._pane == null || !this._pane.isEnabled()) {
            return;
        }
        int tabIndex = this._tabbedPaneUI.tabForCoordinate(this._pane, e.getX(), e.getY());
        if (tabIndex == -1) {
            return;
        }
        if (this._pane.getUnclosables().contains(tabIndex)) {
            return;
        }
        if (this._pane.getSeparators().contains(tabIndex)) {
            return;
        }
        Rectangle r = this._tabbedPaneUI.closeRectFor(tabIndex);
        this._closedIndex = r.contains(new Point(e.getX(), e.getY())) ? tabIndex : -1;
        this._pane.repaint();
    }
}

